/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeFBNetworkElementName;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractInterfaceSection
extends AbstractSection {
    protected Text nameText;
    protected Text commentText;
    private TableViewer inputViewer;
    private static final String NAME_PROPERTY = "name";
    private static final String VALUE_PROPERTY = "value";
    private static final String COMMENT_PROPERTY = "comment";

    protected INamedElement getType() {
        if (this.type instanceof FBNetworkElement) {
            return (FBNetworkElement)this.type;
        }
        if (this.type instanceof Device) {
            return (Device)this.type;
        }
        if (this.type instanceof Resource) {
            return (Resource)this.type;
        }
        return null;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFBInfoGroup(parent);
        this.createInputInfoGroup(parent);
    }

    protected void createFBInfoGroup(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, "Instance Name:");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractInterfaceSection.this.removeContentAdapter();
                AbstractInterfaceSection.this.executeCommand((Command)AbstractInterfaceSection.this.getRenameCommand(AbstractInterfaceSection.this.nameText.getText()));
                AbstractInterfaceSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(composite, "Instance Comment:");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractInterfaceSection.this.removeContentAdapter();
                AbstractInterfaceSection.this.executeCommand((Command)new ChangeCommentCommand(AbstractInterfaceSection.this.getType(), AbstractInterfaceSection.this.commentText.getText()));
                AbstractInterfaceSection.this.addContentAdapter();
            }
        });
    }

    private void createInputInfoGroup(Composite parent) {
        Group inputGroup = this.getWidgetFactory().createGroup(parent, "Inputs");
        inputGroup.setLayout((Layout)new GridLayout(1, false));
        inputGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputViewer = new TableViewer((Composite)inputGroup, 67844);
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        gridDataVersionViewer.minimumHeight = 80;
        gridDataVersionViewer.widthHint = 400;
        this.inputViewer.getControl().setLayoutData((Object)gridDataVersionViewer);
        Table table = this.inputViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.inputViewer.getTable(), 16384);
        column1.setText(NAME_PROPERTY);
        TableColumn column2 = new TableColumn(this.inputViewer.getTable(), 16384);
        column2.setText(VALUE_PROPERTY);
        TableColumn column3 = new TableColumn(this.inputViewer.getTable(), 16384);
        column3.setText(COMMENT_PROPERTY);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 90));
        table.setLayout((Layout)layout);
        this.inputViewer.setContentProvider((IContentProvider)new InputContentProvider());
        this.inputViewer.setLabelProvider((IBaseLabelProvider)new InputLabelProvider());
        this.inputViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.inputViewer.setColumnProperties(new String[]{NAME_PROPERTY, VALUE_PROPERTY, COMMENT_PROPERTY});
        this.inputViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return AbstractInterfaceSection.VALUE_PROPERTY.equals(property) || AbstractInterfaceSection.COMMENT_PROPERTY.equals(property);
            }

            public Object getValue(Object element, String property) {
                if (AbstractInterfaceSection.VALUE_PROPERTY.equals(property)) {
                    return AbstractInterfaceSection.getVarDeclarationValue((VarDeclaration)element);
                }
                if (AbstractInterfaceSection.COMMENT_PROPERTY.equals(property)) {
                    return ((INamedElement)element).getComment() != null ? ((INamedElement)element).getComment() : "";
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                Object data = tableItem.getData();
                ChangeValueCommand cmd = null;
                if (AbstractInterfaceSection.VALUE_PROPERTY.equals(property)) {
                    cmd = new ChangeValueCommand((VarDeclaration)data, value.toString());
                } else if (AbstractInterfaceSection.COMMENT_PROPERTY.equals(property)) {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                }
                if (cmd != null && AbstractInterfaceSection.this.commandStack != null) {
                    AbstractInterfaceSection.this.executeCommand((Command)cmd);
                    AbstractInterfaceSection.this.inputViewer.refresh(data);
                }
            }
        });
    }

    private static String getVarDeclarationValue(VarDeclaration v) {
        return v.getValue() != null && v.getValue().getValue() != null ? v.getValue().getValue() : "";
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.commandStack = this.getCommandStack(part, input);
        if (this.commandStack == null) {
            this.nameText.setEnabled(false);
            this.commentText.setEnabled(false);
            this.inputViewer.setCellModifier(null);
        }
        this.setType(input);
    }

    public void refresh() {
        if (this.type != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractInterfaceSection.this.nameText.isDisposed() && !AbstractInterfaceSection.this.nameText.getParent().isDisposed()) {
                        CommandStack commandStackBuffer = AbstractInterfaceSection.this.commandStack;
                        AbstractInterfaceSection.this.commandStack = null;
                        if (AbstractInterfaceSection.this.type instanceof AdapterFB) {
                            AbstractInterfaceSection.this.nameText.setEnabled(false);
                        }
                        AbstractInterfaceSection.this.nameText.setText(AbstractInterfaceSection.this.getType().getName() != null ? AbstractInterfaceSection.this.getType().getName() : "");
                        AbstractInterfaceSection.this.commentText.setText(AbstractInterfaceSection.this.getType().getComment() != null ? AbstractInterfaceSection.this.getType().getComment() : "");
                        AbstractInterfaceSection.this.inputViewer.setInput((Object)AbstractInterfaceSection.this.getType());
                        AbstractInterfaceSection.this.commandStack = commandStackBuffer;
                    }
                }
            });
        }
    }

    private ChangeNameCommand getRenameCommand(String newValue) {
        INamedElement element = this.getType();
        if (element instanceof FBNetworkElement) {
            return new ChangeFBNetworkElementName((FBNetworkElement)element, newValue);
        }
        return new ChangeNameCommand(this.getType(), this.nameText.getText());
    }

    public class InputContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FBNetworkElement) {
                return ((FBNetworkElement)inputElement).getInterface().getInputVars().toArray();
            }
            if (inputElement instanceof Device) {
                return ((Device)inputElement).getVarDeclarations().toArray();
            }
            if (inputElement instanceof Resource) {
                return ((Resource)inputElement).getVarDeclarations().toArray();
            }
            return new Object[0];
        }
    }

    public class InputLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof VarDeclaration) {
                switch (columnIndex) {
                    case 0: {
                        return ((VarDeclaration)element).getName();
                    }
                    case 1: {
                        return AbstractInterfaceSection.getVarDeclarationValue((VarDeclaration)element);
                    }
                    case 2: {
                        return ((VarDeclaration)element).getComment() != null ? ((VarDeclaration)element).getComment() : "";
                    }
                }
            }
            return element.toString();
        }
    }
}

