/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.figures.VerticalLineCompartmentFigure;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public class ToolTipFigure
extends Figure {
    protected VerticalLineCompartmentFigure line;

    public ToolTipFigure(INamedElement element) {
        ToolbarLayout mainLayout = new ToolbarLayout(false);
        this.setLayoutManager((LayoutManager)mainLayout);
        mainLayout.setStretchMinorAxis(true);
        String nameLine = element.getName();
        if (element instanceof VarDeclaration && ((VarDeclaration)element).getType() != null) {
            nameLine = String.valueOf(nameLine) + " - " + ((VarDeclaration)element).getType().getName();
        }
        this.add((IFigure)new Label(nameLine));
        this.line = new VerticalLineCompartmentFigure();
        this.add((IFigure)this.line);
        String comment = element.getComment();
        if (comment != null && !comment.isEmpty()) {
            this.line.add((IFigure)new Label(comment));
        }
        if (element instanceof Event) {
            this.addWiths((Event)element);
        } else if (element instanceof VarDeclaration) {
            this.addVarDefaultValue((VarDeclaration)element);
        }
    }

    private void addWiths(Event element) {
        EList withs = element.getWith();
        if (!withs.isEmpty()) {
            boolean first = true;
            StringBuilder withText = new StringBuilder("With: [");
            for (With with : withs) {
                if (first) {
                    first = false;
                } else {
                    withText.append(", ");
                }
                if (with == null || with.getVariables() == null) continue;
                withText.append(with.getVariables().getName());
            }
            withText.append("]");
            this.line.add((IFigure)new Label(withText.toString()));
        }
    }

    private void addVarDefaultValue(VarDeclaration var) {
        VarDeclaration typeVar = ToolTipFigure.getTypevariable(var);
        if (typeVar != null && typeVar.getVarInitialization() != null) {
            String initvalue = "Inital value: ";
            if (typeVar.getVarInitialization().getInitialValue() != null && !typeVar.getVarInitialization().getInitialValue().isEmpty()) {
                initvalue = String.valueOf(initvalue) + var.getVarInitialization().getInitialValue();
            }
            this.line.add((IFigure)new Label(initvalue));
        }
    }

    private static VarDeclaration getTypevariable(VarDeclaration var) {
        if (var.eContainer() instanceof Device) {
            Device dev = (Device)var.eContainer();
            if (dev.getType() != null) {
                for (VarDeclaration typeVar : dev.getType().getVarDeclaration()) {
                    if (!typeVar.getName().equals(var.getName())) continue;
                    return typeVar;
                }
            }
        } else if (var.getFBNetworkElement() != null && var.getFBNetworkElement().getType() instanceof FBType) {
            return ((FBType)var.getFBNetworkElement().getType()).getInterfaceList().getVariable(var.getName());
        }
        return null;
    }
}

