/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class UpdateFBTypeCommand
extends Command {
    private FB fb;
    private FB copiedFB;
    private PaletteEntry entry;
    private FBNetwork network;
    private CompoundCommand deleteConnCmds = new CompoundCommand();
    private CompoundCommand connCreateCmds = new CompoundCommand();
    private CompoundCommand resourceConnCreateCmds = new CompoundCommand();
    private MapToCommand mapCmd = null;
    private UnmapCommand unmapCmd = null;

    public UpdateFBTypeCommand(FB fb) {
        this.fb = fb;
        this.network = (FBNetwork)fb.eContainer();
    }

    public UpdateFBTypeCommand(FB fb, PaletteEntry entry) {
        this.fb = fb;
        this.network = (FBNetwork)fb.eContainer();
        if (entry instanceof FBTypePaletteEntry || entry instanceof AdapterTypePaletteEntry) {
            this.entry = entry;
        }
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        Resource resource = null;
        List<ConnData> resourceConns = null;
        if (this.fb.isMapped()) {
            if (this.network.equals(this.fb.getResource().getFBNetwork())) {
                this.fb = (FB)this.fb.getOpposite();
                this.network = this.fb.getFbNetwork();
            }
            resource = this.fb.getResource();
            resourceConns = this.getResourceCons();
            this.unmapCmd = new UnmapCommand((FBNetworkElement)this.fb);
            this.unmapCmd.execute();
        }
        this.copyFB(this.fb);
        this.handleApplicationConnections();
        this.copiedFB.setName(this.fb.getName());
        if (resource != null) {
            this.mapCmd = new MapToCommand((FBNetworkElement)this.copiedFB, resource);
            if (this.mapCmd.canExecute()) {
                this.mapCmd.execute();
                this.recreateResourceConns(resourceConns);
            }
        }
    }

    public void redo() {
        if (this.unmapCmd != null) {
            this.unmapCmd.redo();
        }
        this.deleteConnCmds.redo();
        this.replaceFBs(this.fb, this.copiedFB);
        this.connCreateCmds.redo();
        if (this.mapCmd != null) {
            this.mapCmd.redo();
            this.resourceConnCreateCmds.redo();
        }
    }

    public void undo() {
        if (this.mapCmd != null) {
            this.resourceConnCreateCmds.undo();
            this.mapCmd.undo();
        }
        this.connCreateCmds.undo();
        this.replaceFBs(this.copiedFB, this.fb);
        this.deleteConnCmds.undo();
        if (this.unmapCmd != null) {
            this.unmapCmd.undo();
        }
    }

    private void handleApplicationConnections() {
        for (Connection conn : UpdateFBTypeCommand.getAllConnectionsForFB(this.fb)) {
            this.doReconnect(conn, UpdateFBTypeCommand.findUpdatedInterfaceElement(this.copiedFB, this.fb, conn.getSource()), UpdateFBTypeCommand.findUpdatedInterfaceElement(this.copiedFB, this.fb, conn.getDestination()));
        }
    }

    private static List<Connection> getAllConnectionsForFB(FB functionBlock) {
        ArrayList<Connection> retVal = new ArrayList<Connection>();
        for (IInterfaceElement ifEle : functionBlock.getInterface().getAllInterfaceElements()) {
            if (ifEle.isIsInput()) {
                retVal.addAll((Collection<Connection>)ifEle.getInputConnections());
                continue;
            }
            retVal.addAll((Collection<Connection>)ifEle.getOutputConnections());
        }
        return retVal;
    }

    private static IInterfaceElement findUpdatedInterfaceElement(FB copiedFB, FB orgFB, IInterfaceElement orig) {
        if (orig == null) {
            return null;
        }
        IInterfaceElement retval = orig;
        if (orig.getFBNetworkElement() == orgFB) {
            retval = copiedFB.getInterfaceElement(orig.getName());
        }
        return retval;
    }

    private void doReconnect(Connection oldConn, IInterfaceElement source, IInterfaceElement dest) {
        if (!this.isInDeleteConnList(oldConn)) {
            AbstractConnectionCreateCommand dccc;
            FBNetwork fbn = oldConn.getFBNetwork();
            DeleteConnectionCommand cmd = new DeleteConnectionCommand(oldConn);
            cmd.execute();
            this.deleteConnCmds.add((Command)cmd);
            if (source != null && dest != null && (dccc = UpdateFBTypeCommand.createConnCreateCMD(source, fbn)) != null) {
                dccc.setSource(source);
                dccc.setDestination(dest);
                if (dccc.canExecute()) {
                    dccc.execute();
                    this.connCreateCmds.add((Command)dccc);
                }
            }
        }
    }

    private static AbstractConnectionCreateCommand createConnCreateCMD(IInterfaceElement refIE, FBNetwork fbn) {
        AbstractConnectionCreateCommand retVal = null;
        if (refIE instanceof Event) {
            retVal = new EventConnectionCreateCommand(fbn);
        } else if (refIE instanceof AdapterDeclaration) {
            retVal = new AdapterConnectionCreateCommand(fbn);
        } else if (refIE instanceof VarDeclaration) {
            retVal = new DataConnectionCreateCommand(fbn);
        }
        return retVal;
    }

    private boolean isInDeleteConnList(Connection conn) {
        for (Object cmd : this.deleteConnCmds.getCommands()) {
            if (!((DeleteConnectionCommand)((Object)cmd)).getConnectionView().equals(conn)) continue;
            return true;
        }
        return false;
    }

    private void replaceFBs(FB oldFB, FB newFB) {
        this.network.getNetworkElements().remove((Object)oldFB);
        this.network.getNetworkElements().add((Object)newFB);
    }

    private void copyFB(FB srcFB) {
        this.copiedFB = this.createCopiedFBEntry(srcFB);
        this.copiedFB.setInterface((InterfaceList)EcoreUtil.copy((EObject)this.copiedFB.getType().getInterfaceList()));
        this.copiedFB.setName(srcFB.getName());
        for (VarDeclaration var : this.copiedFB.getInterface().getInputVars()) {
            if (var.getValue() != null) continue;
            var.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        this.copiedFB.setX(srcFB.getX());
        this.copiedFB.setY(srcFB.getY());
        this.createValues(this.copiedFB);
        UpdateFBTypeCommand.pasteParams(srcFB, this.copiedFB);
        this.replaceFBs(srcFB, this.copiedFB);
    }

    protected FB createCopiedFBEntry(FB srcFB) {
        FB copy = null;
        if (srcFB instanceof AdapterFB) {
            AdapterFB aFB = LibraryElementFactory.eINSTANCE.createAdapterFB();
            aFB.setAdapterDecl(((AdapterFB)srcFB).getAdapterDecl());
            copy = aFB;
        } else {
            copy = LibraryElementFactory.eINSTANCE.createFB();
        }
        if (this.entry == null) {
            copy.setPaletteEntry(srcFB.getPaletteEntry());
        } else {
            copy.setPaletteEntry(this.entry);
        }
        return copy;
    }

    private static void pasteParams(FB src, FB dst) {
        InterfaceList interfaceList = src.getInterface();
        if (interfaceList != null) {
            for (VarDeclaration varDecl : interfaceList.getInputVars()) {
                Value value;
                if (dst.getInterfaceElement(varDecl.getName()) == null || (value = varDecl.getValue()) == null || value.getValue() == null) continue;
                Value newValue = LibraryElementFactory.eINSTANCE.createValue();
                newValue.setValue(value.getValue());
                dst.getInterfaceElement(varDecl.getName()).setValue(newValue);
            }
        }
    }

    protected void createValues(FB copiedFB) {
        for (IInterfaceElement element : copiedFB.getInterface().getInputVars()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            element.setValue(value);
        }
    }

    private List<ConnData> getResourceCons() {
        ArrayList<ConnData> retVal = new ArrayList<ConnData>();
        FB resFB = (FB)this.fb.getOpposite();
        for (Connection conn : UpdateFBTypeCommand.getAllConnectionsForFB(resFB)) {
            IInterfaceElement source = conn.getSource();
            IInterfaceElement dest = conn.getDestination();
            if (!source.getFBNetworkElement().isMapped() || !dest.getFBNetworkElement().isMapped()) {
                retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
                continue;
            }
            if ((source.getFBNetworkElement() != resFB || dest.getFBNetworkElement().getOpposite().getFbNetwork() == this.fb.getFbNetwork()) && (dest.getFBNetworkElement() != resFB || source.getFBNetworkElement().getOpposite().getFbNetwork() == this.fb.getFbNetwork())) continue;
            retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
        }
        return retVal;
    }

    private void recreateResourceConns(List<ConnData> resourceConns) {
        FB orgMappedFB = (FB)this.unmapCmd.getMappedFBNetworkElement();
        FB copiedMappedFB = (FB)this.copiedFB.getOpposite();
        for (ConnData connData : resourceConns) {
            AbstractConnectionCreateCommand dccc;
            IInterfaceElement source = UpdateFBTypeCommand.findUpdatedInterfaceElement(copiedMappedFB, orgMappedFB, connData.source);
            IInterfaceElement dest = UpdateFBTypeCommand.findUpdatedInterfaceElement(copiedMappedFB, orgMappedFB, connData.dest);
            if (source == null || dest == null || (dccc = UpdateFBTypeCommand.createConnCreateCMD(source, copiedMappedFB.getFbNetwork())) == null) continue;
            dccc.setSource(source);
            dccc.setDestination(dest);
            if (!dccc.canExecute()) continue;
            dccc.execute();
            this.resourceConnCreateCmds.add((Command)dccc);
        }
    }

    class ConnData {
        public IInterfaceElement source;
        public IInterfaceElement dest;

        public ConnData(IInterfaceElement source, IInterfaceElement dest) {
            this.source = source;
            this.dest = dest;
        }
    }
}

