/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractCreateFBNetworkElementCommand
extends Command {
    protected IEditorPart editor;
    protected FBNetworkElement element;
    protected FBNetwork fbNetwork;
    private int x;
    private int y;

    public AbstractCreateFBNetworkElementCommand(FBNetwork fbNetwork, int x, int y) {
        this.fbNetwork = fbNetwork;
        this.x = x;
        this.y = y;
        this.editor = Abstract4DIACUIPlugin.getCurrentActiveEditor();
    }

    public boolean canExecute() {
        return this.fbNetwork != null;
    }

    public boolean canUndo() {
        return this.editor.equals(Abstract4DIACUIPlugin.getCurrentActiveEditor());
    }

    public void execute() {
        this.setLabel(String.valueOf(this.getLabel()) + "(" + (this.editor != null ? this.editor.getTitle() : "") + ")");
        this.element.setInterface((InterfaceList)EcoreUtil.copy((EObject)this.getTypeInterfaceList()));
        this.element.setX(this.x);
        this.element.setY(this.y);
        this.createValues();
        this.fbNetwork.getNetworkElements().add((Object)this.element);
        this.element.setName(NameRepository.createUniqueName((INamedElement)this.element, (String)this.getInitalInstanceName()));
    }

    public void redo() {
        this.fbNetwork.getNetworkElements().add((Object)this.element);
    }

    public void undo() {
        this.fbNetwork.getNetworkElements().remove((Object)this.element);
    }

    public void updateCreatePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    protected String getInitalInstanceName() {
        return this.element.getTypeName();
    }

    protected void createValues() {
        for (IInterfaceElement element : this.element.getInterface().getInputVars()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            element.setValue(value);
        }
    }

    protected abstract InterfaceList getTypeInterfaceList();
}

