/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.fordiac.ide.ui.controls.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.controls.editors.I4diacModelEditor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorPart;

public class DeleteFBNetworkElementCommand
extends Command {
    private IEditorPart editor;
    private FBNetwork fbParent;
    private final FBNetworkElement element;
    private CompoundCommand cmds = new CompoundCommand();

    public DeleteFBNetworkElementCommand(FBNetworkElement element) {
        super("Delete FB or Subapplication");
        this.element = element;
    }

    public FBNetworkElement getFBNetworkElement() {
        return this.element;
    }

    public boolean canUndo() {
        return this.editor != null && this.editor.equals(Abstract4DIACUIPlugin.getCurrentActiveEditor());
    }

    public boolean canExecute() {
        if (this.element instanceof FB && ((FB)this.element).isResourceTypeFB()) {
            Abstract4DIACUIPlugin.statusLineErrorMessage((String)Messages.DeleteFBNetworkElement);
            return false;
        }
        return this.element != null && this.element.getFbNetwork() != null;
    }

    public void execute() {
        this.editor = Abstract4DIACUIPlugin.getCurrentActiveEditor();
        this.fbParent = this.element.getFbNetwork();
        if (this.element.isMapped()) {
            this.cmds.add((Command)new UnmapCommand(this.element));
        }
        this.getDeleteConnections(this.element);
        if (this.cmds.canExecute()) {
            this.cmds.execute();
        }
        this.fbParent.getNetworkElements().remove((Object)this.element);
        if (this.element instanceof SubApp) {
            this.closeSubApplicationEditor((SubApp)this.element);
        }
    }

    public void undo() {
        this.fbParent.getNetworkElements().add((Object)this.element);
        if (this.cmds.canUndo()) {
            this.cmds.undo();
        }
    }

    public void redo() {
        if (this.cmds.canRedo()) {
            this.cmds.redo();
        }
        this.fbParent.getNetworkElements().remove((Object)this.element);
    }

    private void getDeleteConnections(FBNetworkElement element) {
        for (IInterfaceElement intElement : element.getInterface().getAllInterfaceElements()) {
            EList connList = null;
            connList = intElement.isIsInput() ? intElement.getInputConnections() : intElement.getOutputConnections();
            if (connList == null) continue;
            connList.forEach(con -> this.cmds.add((Command)new DeleteConnectionCommand((Connection)con)));
        }
    }

    private void closeSubApplicationEditor(SubApp subapp) {
        EditorUtils.closeEditorsFiltered(editor -> editor instanceof I4diacModelEditor && subapp.getSubAppNetwork() == ((I4diacModelEditor)editor).getModel());
    }
}

