/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.data.BaseType1;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.ReferencedTypeNotFoundException;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DEVImporter {
    public static DeviceType importDEVType(IFile devFile, Palette palette) {
        if (devFile.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            try {
                dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(devFile.getContents());
                Element rootNode = document.getDocumentElement();
                DeviceType type = LibraryElementFactory.eINSTANCE.createDeviceType();
                return DEVImporter.parseDEVType(type, rootNode, palette);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static DeviceType parseDEVType(DeviceType type, Node rootNode, Palette palette) throws TypeImportException, ReferencedTypeNotFoundException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[12] lbl101 : CaseStatement: default:\u000a, @NONE, blocks:[12] lbl101 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Resource parseResource(Node node, Palette palette) throws TypeImportException {
        Node y;
        Node x;
        Resource res = LibraryElementFactory.eINSTANCE.createResource();
        NodeList childNodes = node.getChildNodes();
        NamedNodeMap map = node.getAttributes();
        Node name = map.getNamedItem("Name");
        if (name == null) {
            throw new TypeImportException(Messages.DEVImporter_ERROR_ResourceNameHasToBeSet);
        }
        res.setName(name.getNodeValue());
        Node type = map.getNamedItem("Type");
        if (type == null) {
            throw new TypeImportException(Messages.DEVImporter_ERROR_ResourceTypeHasToBeSet);
        }
        PaletteEntry entry = null;
        entry = type.getNodeValue().contains("/") ? palette.getTypeEntryForPath(type.getNodeValue(), ".RES") : palette.getTypeEntry(type.getNodeName());
        res.setPaletteEntry(entry);
        Node comment = map.getNamedItem("Comment");
        if (comment != null) {
            res.setComment(comment.getNodeValue());
        }
        if ((x = map.getNamedItem("x")) != null) {
            res.setX(x.getNodeValue());
        }
        if ((y = map.getNamedItem("y")) != null) {
            res.setY(y.getNodeValue());
        }
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("Parameter")) {
                try {
                    res.getVarDeclarations().add((Object)ImportUtils.parseParameter(n));
                }
                catch (TypeImportException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
            }
            if (n.getNodeName().equals("FBNetwork")) {
                res.setFBNetwork(new ResDevFBNetworkImporter(palette, (EList<VarDeclaration>)res.getVarDeclarations()).parseFBNetwork(n));
            }
            ++i;
        }
        return res;
    }

    public static List<String> getReferencedTypes(File file) {
        ArrayList<String> references = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(file);
            Element rootNode = document.getDocumentElement();
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Resource")) {
                    String type = "";
                    type = n.getAttributes().getNamedItem("Type").getNodeValue();
                    references.add(type);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return references;
    }

    private static void parseDeviceTypeAttributeDeclaration(DeviceType device, Node node) {
        NamedNodeMap attributeMap = node.getAttributes();
        AttributeDeclaration attributeDeclaration = LibraryElementFactory.eINSTANCE.createAttributeDeclaration();
        attributeDeclaration.setName(attributeMap.getNamedItem("Name").getNodeValue());
        attributeDeclaration.setComment(attributeMap.getNamedItem("Comment").getNodeValue());
        attributeDeclaration.setInitialValue(attributeMap.getNamedItem("InitialValue").getNodeValue());
        attributeDeclaration.setType(BaseType1.getByName(attributeMap.getNamedItem("Type").getNodeValue()));
        device.getAttributeDeclarations().add((Object)attributeDeclaration);
    }

    private static void parseDeviceTypeAttribute(DeviceType device, Node node) {
        NamedNodeMap attributeMap = node.getAttributes();
        if (CommonElementImporter.isProfileAttribute(attributeMap)) {
            DEVImporter.parseProfile(device, attributeMap);
        }
    }

    private static void parseProfile(DeviceType device, NamedNodeMap attributeMap) {
        Node value = attributeMap.getNamedItem("Value");
        if (value != null) {
            device.setProfile(value.getNodeValue());
        }
    }
}

