/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.ArrayList;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.model.monitoring.Breakpoints;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringFactory;
import org.eclipse.fordiac.ide.model.monitoring.PortElement;
import org.eclipse.fordiac.ide.monitoring.IMonitoringListener;

public abstract class AbstractMonitoringManager {
    protected final Breakpoints breakpoints = MonitoringFactory.eINSTANCE.createBreakpoints();
    protected final ArrayList<IMonitoringListener> monitoringListeners = new ArrayList();
    ArrayList<IMonitoringListener> watchesAdapter = new ArrayList();

    public void registerMonitoringListener(IMonitoringListener listener) {
        if (!this.monitoringListeners.contains(listener)) {
            this.monitoringListeners.add(listener);
        }
    }

    public void addBreakpointsAdapter(EContentAdapter adapter) {
        if (!this.breakpoints.eAdapters().contains((Object)adapter)) {
            this.breakpoints.eAdapters().add((Object)adapter);
        }
    }

    public void removeBreakpointsAdapter(EContentAdapter adapter) {
        this.breakpoints.eAdapters().remove((Object)adapter);
    }

    public void addWatchesAdapter(IMonitoringListener adapter) {
        if (!this.watchesAdapter.contains(adapter)) {
            this.watchesAdapter.add(adapter);
        }
    }

    public void removeWatchesAdapter(IMonitoringListener adapter) {
        this.watchesAdapter.remove(adapter);
    }

    public void notifyWatchesAdapterPortAdded(PortElement port) {
        for (IMonitoringListener adapter : this.watchesAdapter) {
            adapter.notifyAddPort(port);
        }
    }

    public void notifyWatchesAdapterPortRemoved(PortElement port) {
        for (IMonitoringListener adapter : this.watchesAdapter) {
            adapter.notifyRemovePort(port);
        }
    }

    public abstract void disableSystem(String var1);

    public abstract void enableSystem(String var1);
}

