/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.PortElement;
import org.eclipse.fordiac.ide.monitoring.AbstractMonitoringManager;
import org.eclipse.fordiac.ide.monitoring.IMonitoringListener;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.fordiac.ide.monitoring.communication.TCPCommunicationObject;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MonitoringManager
extends AbstractMonitoringManager {
    private static MonitoringManager instance;
    private final Map<String, SystemMonitoringData> systemMonitoringData = new Hashtable<String, SystemMonitoringData>();

    public static MonitoringManager getInstance() {
        if (instance == null) {
            instance = new MonitoringManager();
        }
        return instance;
    }

    private MonitoringManager() {
    }

    private void notifyAddPort(PortElement port) {
        for (IMonitoringListener monitoringListener : this.monitoringListeners) {
            monitoringListener.notifyAddPort(port);
        }
    }

    private void notifyRemovePort(PortElement port) {
        for (IMonitoringListener monitoringListener : this.monitoringListeners) {
            monitoringListener.notifyRemovePort(port);
        }
    }

    private void notifyTriggerEvent(PortElement port) {
        for (IMonitoringListener monitoringListener : this.monitoringListeners) {
            monitoringListener.notifyTriggerEvent(port);
        }
    }

    public MonitoringBaseElement getMonitoringElement(IInterfaceElement port) {
        if (port != null) {
            for (SystemMonitoringData data : this.systemMonitoringData.values()) {
                MonitoringBaseElement element = data.getMonitoredElement(port);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    public void addMonitoringElement(MonitoringBaseElement element) {
        PortElement port = element.getPort();
        SystemMonitoringData data = this.getSystemMonitoringData(port.getSystem());
        data.addMonitoringElement(element);
        this.notifyAddPort(port);
        if (element instanceof MonitoringElement) {
            this.notifyWatchesAdapterPortAdded(port);
        }
    }

    public void removeMonitoringElement(MonitoringBaseElement element) {
        SystemMonitoringData data = this.getSystemMonitoringData(element.getPort().getSystem());
        data.removeMonitoringElement(element);
        if (element instanceof MonitoringElement) {
            this.notifyWatchesAdapterPortRemoved(element.getPort());
        }
        this.notifyRemovePort(element.getPort());
    }

    public boolean containsPort(IInterfaceElement interfaceElement) {
        if (interfaceElement != null) {
            return this.getMonitoringElement(interfaceElement) != null;
        }
        return false;
    }

    public Collection<MonitoringBaseElement> getElementsToMonitor() {
        ArrayList<MonitoringBaseElement> elements = new ArrayList<MonitoringBaseElement>();
        for (SystemMonitoringData data : this.systemMonitoringData.values()) {
            elements.addAll(data.getMonitoredElements());
        }
        return elements;
    }

    @Override
    public void enableSystem(String system) {
        AutomationSystem automationSystem = SystemManager.INSTANCE.getSystemForName(system);
        if (automationSystem == null) {
            Activator.getDefault().logError(String.valueOf(system) + " could not be found.");
            return;
        }
        SystemMonitoringData systemData = this.getSystemMonitoringData(system);
        systemData.enableSystem();
    }

    @Override
    public void disableSystem(String system) {
        AutomationSystem automationSystem = SystemManager.INSTANCE.getSystemForName(system);
        if (automationSystem == null) {
            Activator.getDefault().logError(String.valueOf(system) + " could not be found for deactivating monitoring.");
            return;
        }
        SystemMonitoringData systemData = this.getSystemMonitoringData(system);
        systemData.disableSystem();
    }

    public boolean monitoringForSystemEnabled(AutomationSystem system) {
        SystemMonitoringData data = this.getSystemMonitoringData(system);
        return data.monitoringForSystemEnabled();
    }

    public void toggleBreakpoint(MonitoringBaseElement element, BreakPoint set) {
        MonitoringElement monitoringElement;
        SystemMonitoringData data;
        TCPCommunicationObject commObject;
        if (element instanceof MonitoringElement && (commObject = (data = this.getSystemMonitoringData((monitoringElement = (MonitoringElement)element).getPort().getSystem())).getCommObject(monitoringElement.getPort().getDevice())) != null) {
            commObject.toggleBreakpoint(monitoringElement, set);
            if (set.equals((Object)BreakPoint.add)) {
                monitoringElement.setBreakpoint(true);
                this.breakpoints.getBreakpoints().add((Object)monitoringElement);
            } else if (set.equals((Object)BreakPoint.remove)) {
                monitoringElement.setBreakpoint(false);
                this.breakpoints.getBreakpoints().remove((Object)monitoringElement);
            } else {
                set.equals((Object)BreakPoint.clear);
            }
        }
    }

    public void triggerEvent(IInterfaceElement interfaceElement) {
        MonitoringElement monitoringElement;
        SystemMonitoringData data;
        TCPCommunicationObject commObject;
        MonitoringBaseElement element = this.getMonitoringElement(interfaceElement);
        if (element instanceof MonitoringElement && (commObject = (data = this.getSystemMonitoringData((monitoringElement = (MonitoringElement)element).getPort().getSystem())).getCommObject(monitoringElement.getPort().getDevice())) != null) {
            commObject.triggerEvent(monitoringElement);
            this.notifyTriggerEvent(monitoringElement.getPort());
        }
    }

    public void writeValue(MonitoringElement element, String value) {
        AutomationSystem automationSystem = element.getPort().getSystem();
        if (automationSystem == null) {
            Activator.getDefault().logError("System could not be found to write value (" + element.getPort() + ").");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("System could not be found for write value (" + element.getPort() + ")."));
            return;
        }
        Device device = element.getPort().getDevice();
        if (device == null) {
            Activator.getDefault().logError("Device could not be found for write value (" + element.getPort() + ").");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Device could not be found for write value (" + element.getPort() + ")."));
            return;
        }
        TCPCommunicationObject commObject = this.getSystemMonitoringData(automationSystem).getCommObject(device);
        if (commObject != null) {
            commObject.writeValue(element, value);
        }
    }

    public void forceValue(MonitoringElement element, String value) {
        AutomationSystem automationSystem = element.getPort().getSystem();
        if (automationSystem == null) {
            Activator.getDefault().logError("System could not be found to force value (" + element.getPort() + ").");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("System could not be found for force value (" + element.getPort() + ")."));
            return;
        }
        Device device = element.getPort().getDevice();
        if (device == null) {
            Activator.getDefault().logError("Device could not be found for force value (" + element.getPort() + ").");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Device could not be found for force value (" + element.getPort() + ")."));
            return;
        }
        element.forceValue(value);
        TCPCommunicationObject commObject = this.getSystemMonitoringData(automationSystem).getCommObject(device);
        if (commObject != null) {
            if (element.isForce()) {
                commObject.forceValue(element, value);
            } else {
                commObject.clearForce(element);
            }
        }
    }

    public MonitoringBaseElement getMonitoringElementByPortString(String systemName, String portString) {
        return this.getSystemMonitoringData(systemName).getMonitoringElementByPortString(portString);
    }

    private SystemMonitoringData getSystemMonitoringData(String systemName) {
        SystemMonitoringData retVal = this.systemMonitoringData.get(systemName);
        if (retVal == null) {
            retVal = this.createSystemMonitoringData(SystemManager.INSTANCE.getSystemForName(systemName));
        }
        return retVal;
    }

    private SystemMonitoringData getSystemMonitoringData(AutomationSystem system) {
        SystemMonitoringData retVal = this.systemMonitoringData.get(system.getName());
        if (retVal == null) {
            retVal = this.createSystemMonitoringData(system);
        }
        return retVal;
    }

    private SystemMonitoringData createSystemMonitoringData(AutomationSystem system) {
        SystemMonitoringData newData = new SystemMonitoringData(system);
        this.systemMonitoringData.put(system.getName(), newData);
        return newData;
    }

    public static enum BreakPoint {
        add,
        remove,
        clear;

    }
}

