/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.controls.editors;

import org.eclipse.fordiac.ide.ui.controls.editors.EditorAction;
import org.eclipse.fordiac.ide.ui.controls.editors.EditorFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class EditorUtils {
    public static final EditorAction CloseEditor = part -> PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(part, false);

    private EditorUtils() {
        throw new AssertionError();
    }

    public static IEditorPart findEditor(EditorFilter filter) {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor != null && filter.filter(editor)) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    public static void forEachOpenEditorFiltered(EditorFilter filter, EditorAction action) {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor != null && filter.filter(editor)) {
                action.run(editor);
            }
            ++n2;
        }
    }

    public static void closeEditorsFiltered(EditorFilter filter) {
        EditorUtils.forEachOpenEditorFiltered(filter, CloseEditor);
    }
}

