/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.imageprovider;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImageURLConnection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class FordiacImageURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final String FORDIAC_IMAGE_PROTOCOL = "fordiacimage";
    private static FordiacImageURLStreamHandlerService instance;
    private ServiceRegistration<URLStreamHandlerService> iconUrlHandler;

    public static FordiacImageURLStreamHandlerService getInstance() {
        if (instance == null) {
            instance = new FordiacImageURLStreamHandlerService();
        }
        return instance;
    }

    public void register() {
        Bundle bundle = FrameworkUtil.getBundle(FordiacImageURLStreamHandlerService.class);
        BundleContext bundleContext = bundle.getBundleContext();
        try {
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
            properties.put("url.handler.protocol", new String[]{FORDIAC_IMAGE_PROTOCOL});
            this.iconUrlHandler = bundleContext.registerService(URLStreamHandlerService.class, (Object)this, properties);
        }
        catch (Exception e) {
            Activator.getDefault().logError("Could not register icon URL handler.", e);
        }
        Activator.getDefault().logError("Icon URL handler registered.");
    }

    public void unregister() {
        try {
            if (this.iconUrlHandler != null) {
                this.iconUrlHandler.unregister();
                this.iconUrlHandler = null;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError("Could not register icon URL handler.", e);
        }
    }

    public URLConnection openConnection(URL u) throws IOException {
        return new FordiacImageURLConnection(u);
    }
}

