/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.storage;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.egit.internal.storage.AbstractGitResourceVariant;
import org.eclipse.emf.compare.egit.internal.storage.WorkspaceGitBlobStorage;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.team.core.TeamException;

public class TreeParserResourceVariant
extends AbstractGitResourceVariant {
    private IPath workspacePath;

    private TreeParserResourceVariant(Repository repository, String path, IPath workspacePath, boolean isContainer, ObjectId objectId, int rawMode) {
        super(repository, path, isContainer, objectId, rawMode);
        this.workspacePath = workspacePath;
    }

    public static TreeParserResourceVariant create(Repository repository, CanonicalTreeParser treeParser, IPath workspacePath) {
        String path = treeParser.getEntryPathString();
        boolean isContainer = FileMode.TREE.equals(treeParser.getEntryFileMode());
        ObjectId objectId = treeParser.getEntryObjectId();
        int rawMode = treeParser.getEntryRawMode();
        return new TreeParserResourceVariant(repository, path, workspacePath, isContainer, objectId, rawMode);
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        return new WorkspaceGitBlobStorage(this.repository, this.path, this.workspacePath, this.objectId);
    }
}

