/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.text.NumberFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class IUDetailsLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider,
IFontProvider {
    static final int PRIMARY_COLUMN = 0;
    static final String BLANK = "";
    private String toolTipProperty = null;
    private FilteredTree filteredTree;
    private boolean useBoldFont = false;
    private boolean showingId = false;
    private IUColumnConfig[] columnConfig;
    Shell shell;
    HashMap<IIUElement, Job> jobs = new HashMap();

    public IUDetailsLabelProvider() {
        this(null, null, null);
    }

    public IUDetailsLabelProvider(FilteredTree filteredTree, IUColumnConfig[] columnConfig, Shell shell) {
        this.filteredTree = filteredTree;
        this.columnConfig = columnConfig == null ? ProvUI.getIUColumnConfig() : columnConfig;
        IUColumnConfig[] iUColumnConfigArray = this.columnConfig;
        int n = this.columnConfig.length;
        int n2 = 0;
        while (n2 < n) {
            IUColumnConfig config = iUColumnConfigArray[n2];
            if (config.getColumnType() == 0) {
                this.showingId = true;
                break;
            }
            ++n2;
        }
        this.shell = shell;
    }

    public String getText(Object obj) {
        return this.getColumnText(obj, 0);
    }

    public Image getImage(Object obj) {
        return this.getColumnImage(obj, 0);
    }

    public String getColumnText(Object element, int columnIndex) {
        IInstallableUnit iu;
        int columnContent = 0;
        if (columnIndex < this.columnConfig.length) {
            columnContent = this.columnConfig[columnIndex].getColumnType();
        }
        if ((iu = ProvUI.getAdapter(element, IInstallableUnit.class)) == null) {
            if (columnIndex == 0) {
                if (element instanceof ProvElement) {
                    return ((ProvElement)element).getLabel(element);
                }
                return element.toString();
            }
            return BLANK;
        }
        switch (columnContent) {
            case 0: {
                return iu.getId();
            }
            case 1: {
                String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
                if (name != null) {
                    return name;
                }
                if (this.showingId) {
                    return BLANK;
                }
                return iu.getId();
            }
            case 5: {
                String description = iu.getProperty("org.eclipse.equinox.p2.description", null);
                if (description != null) {
                    return description;
                }
                return BLANK;
            }
            case 2: {
                if (element instanceof IIUElement) {
                    if (((IIUElement)element).shouldShowVersion()) {
                        return iu.getVersion().toString();
                    }
                    return BLANK;
                }
                return iu.getVersion().toString();
            }
            case 4: {
                return iu.getProperty("org.eclipse.equinox.p2.provider", null);
            }
            case 3: {
                if (element instanceof IIUElement && ((IIUElement)element).shouldShowSize()) {
                    return this.getIUSize((IIUElement)element);
                }
                return BLANK;
            }
        }
        return BLANK;
    }

    public Image getColumnImage(Object element, int index) {
        if (index == 0) {
            if (element instanceof ProvElement) {
                return ((ProvElement)element).getImage(element);
            }
            if (ProvUI.getAdapter(element, IInstallableUnit.class) != null) {
                return ProvUIImages.getImage("obj/iu_obj.png");
            }
        }
        return null;
    }

    private String getIUSize(final IIUElement element) {
        long size = element.getSize();
        if (size != -1L) {
            return this.getFormattedSize(size);
        }
        if (!this.jobs.containsKey(element)) {
            Job resolveJob = new Job(element.getIU().getId()){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (IUDetailsLabelProvider.this.shell == null || IUDetailsLabelProvider.this.shell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    element.computeSize(monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (element.getSize() == -1L) {
                        return Status.OK_STATUS;
                    }
                    if (IUDetailsLabelProvider.this.shell == null || IUDetailsLabelProvider.this.shell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    IUDetailsLabelProvider.this.shell.getDisplay().asyncExec(() -> IUDetailsLabelProvider.this.labelProviderChanged(element));
                    return Status.OK_STATUS;
                }
            };
            this.jobs.put(element, resolveJob);
            resolveJob.setSystem(true);
            resolveJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IUDetailsLabelProvider.this.jobs.remove(element);
                }
            });
            resolveJob.schedule();
        }
        return ProvUIMessages.IUDetailsLabelProvider_ComputingSize;
    }

    private void labelProviderChanged(IIUElement element) {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)element));
        }
    }

    private String getFormattedSize(long size) {
        if (size == -1L || size == -2L) {
            return ProvUIMessages.IUDetailsLabelProvider_Unknown;
        }
        if (size > 1000L) {
            long kb = size / 1000L;
            return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_KB, (Object)NumberFormat.getInstance().format((Object)kb));
        }
        return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_Bytes, (Object)NumberFormat.getInstance().format((Object)size));
    }

    public void setToolTipProperty(String propertyName) {
        this.toolTipProperty = propertyName;
    }

    public String getClipboardText(Object element, String columnDelimiter) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.columnConfig.length) {
            if (i != 0) {
                result.append(columnDelimiter);
            }
            result.append(this.getColumnText(element, i));
            ++i;
        }
        return result.toString();
    }

    public void setUseBoldFontForFilteredItems(boolean useBoldFont) {
        this.useBoldFont = useBoldFont;
    }

    public String getToolTipText(Object element) {
        IInstallableUnit iu = ProvUI.getAdapter(element, IInstallableUnit.class);
        if (iu == null || this.toolTipProperty == null) {
            return null;
        }
        return iu.getProperty(this.toolTipProperty, null);
    }

    public Font getFont(Object element) {
        if (this.filteredTree != null && this.useBoldFont) {
            return FilteredTree.getBoldFont((Object)element, (FilteredTree)this.filteredTree, (PatternFilter)this.filteredTree.getPatternFilter());
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        for (Job job : this.jobs.values()) {
            job.cancel();
        }
    }
}

