/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.contracts.exceptions.ReactionExeption;
import org.eclipse.fordiac.ide.contracts.model.Guarantee;
import org.eclipse.fordiac.ide.contracts.model.Interval;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;

public class Reaction
extends Guarantee {
    private static final int POS_MS = 4;
    private static final int POS_WITHIN = 3;
    private static final int POS_REACTION = 1;
    private static final int GUARANTEE_LENGTH = 5;
    private static final int POSITION_NO = 4;

    Reaction() {
        throw new UnsupportedOperationException("Reaction not Implemented");
    }

    static Guarantee createReaction(String line) throws ReactionExeption {
        String[] parts = line.split(" ");
        if (!Reaction.isCorrectGuarantee(parts)) {
            throw new ReactionExeption("Error with Guarantee: " + line);
        }
        Reaction reaction = new Reaction();
        String[] events = parts[2].split(",");
        reaction.setOutputEvent(events[1].substring(0, events[1].length() - 1));
        reaction.setInputEvent(events[0].substring(1, events[0].length()));
        if (ContractUtils.isInterval(parts, 4, ",")) {
            reaction.setRangeFromInterval(parts, 4);
            return reaction;
        }
        reaction.setTime(new Interval(0, Integer.parseInt(parts[4].substring(0, parts[4].length() - "ms".length()))));
        return reaction;
    }

    private static boolean isCorrectGuarantee(String[] parts) {
        if (parts.length != 5) {
            return false;
        }
        if (!"Reaction".equals(parts[1])) {
            return false;
        }
        if (!"within".equals(parts[3])) {
            return false;
        }
        return "ms".equals(parts[4].subSequence(ContractUtils.getStartPosition(parts, 4), parts[4].length()));
    }

    @Override
    public String asString() {
        StringBuilder comment = new StringBuilder();
        if (this.getMin() == 0 || this.getMin() == this.getMax()) {
            comment.append(ContractUtils.createReactionString(this.getInputEvent(), this.getOutputEvent(), String.valueOf(this.getMax())));
        } else {
            comment.append(ContractUtils.createReactionString(this.getInputEvent(), this.getOutputEvent(), ContractUtils.createInterval(this)));
        }
        comment.append(System.lineSeparator());
        return comment.toString();
    }

    public static boolean isCompatibleWith(Map<String, EList<Guarantee>> mapGuarantees, Map<String, EList<Reaction>> mapReactions) {
        return mapGuarantees.isEmpty() && mapReactions.size() == 1;
    }
}

