/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.policies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;

public class ModifiedResizeablePolicy
extends ResizableEditPolicy {
    private final Insets insets = new Insets(2);
    private IFigure selectionFeedback;

    public void deactivate() {
        super.deactivate();
        this.removeSelectionFeedbackFigure();
    }

    protected void createMoveHandle(List<Handle> handles) {
        handles.add((Handle)new ModifiedMoveHandle(this.getHost(), this.insets, 6));
        this.removeSelectionFeedbackFigure();
    }

    protected IFigure createDragSourceFeedbackFigure() {
        RectangleFigure figure = (RectangleFigure)super.createDragSourceFeedbackFigure();
        figure.setFillXOR(false);
        figure.setOutlineXOR(false);
        figure.setAlpha(50);
        figure.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
        figure.setBackgroundColor(ModifiedMoveHandle.getSelectionColor());
        figure.setLineWidth(2);
        return figure;
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        if (this.isFeedbackRequest(request) && this.selectionFeedback == null && this.handles == null) {
            this.selectionFeedback = this.createSelectionFeedbackFigure();
            if (this.selectionFeedback != null) {
                this.addFeedback(this.selectionFeedback);
            }
        }
    }

    protected IFigure createSelectionFeedbackFigure() {
        return ModifiedNonResizeableEditPolicy.createSelectionFeedbackFigure((EditPart)this.getHost(), 6);
    }

    public void eraseTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        this.removeSelectionFeedbackFigure();
    }

    private void removeSelectionFeedbackFigure() {
        if (this.selectionFeedback != null) {
            this.removeFeedback(this.selectionFeedback);
            this.selectionFeedback = null;
        }
    }

    private boolean isFeedbackRequest(Request request) {
        return "selection".equals(request.getType()) || "selection hover".equals(request.getType()) || this.isValidConnectionRequest(request);
    }

    private boolean isValidConnectionRequest(Request request) {
        AbstractConnectableEditPart acEP;
        GraphicalEditPart graphicalEditPart = this.getHost();
        return graphicalEditPart instanceof AbstractConnectableEditPart && (acEP = (AbstractConnectableEditPart)graphicalEditPart).isConnectable() && ("Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType()) || "connection end".equals(request.getType()));
    }
}

