/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public abstract class TextDirectEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private ZoomManager zoomMananger = null;
    private Font scaledFont;
    private final ZoomListener zoomListener = this::updateScaledFont;

    protected TextDirectEditManager(GraphicalEditPart source, CellEditorLocator locator) {
        super(source, null, locator);
    }

    protected TextDirectEditManager(GraphicalEditPart source, CellEditorLocator locator, Object feature) {
        super(source, null, locator, feature);
    }

    protected void initCellEditor() {
        this.setupActions();
        this.setupZoomHandling();
    }

    protected void bringDown() {
        this.cleanUpActions();
        super.bringDown();
        this.disposeScaledFont();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite);
    }

    protected void unhookListeners() {
        super.unhookListeners();
        ZoomManager zoomManager = this.getZoomManager();
        if (zoomManager != null) {
            zoomManager.removeZoomListener(this.zoomListener);
        }
    }

    private void setupActions() {
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null) {
            this.actionBars = currentActiveEditor.getEditorSite().getActionBars();
            this.saveCurrentActions(this.actionBars);
            this.actionHandler = new CellEditorActionHandler(this.actionBars);
            this.actionHandler.addCellEditor(this.getCellEditor());
            this.actionBars.updateActionBars();
        }
    }

    private void setupZoomHandling() {
        ZoomManager zoomManager = this.getZoomManager();
        if (zoomManager != null) {
            this.updateScaledFont(zoomManager.getZoom());
            zoomManager.addZoomListener(this.zoomListener);
        } else {
            this.getCellEditor().getControl().setFont(this.getEditPart().getFigure().getFont());
        }
    }

    private ZoomManager getZoomManager() {
        EditPartViewer viewer;
        if (this.zoomMananger == null && (viewer = this.getEditPart().getViewer()) != null) {
            this.zoomMananger = (ZoomManager)viewer.getProperty(ZoomManager.class.toString());
        }
        return this.zoomMananger;
    }

    private void cleanUpActions() {
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void updateScaledFont(double zoom) {
        Control control = this.getCellEditor().getControl();
        Font font = this.getEditPart().getFigure().getFont();
        this.disposeScaledFont();
        if (Double.compare(zoom, 1.0) == 0) {
            control.setFont(font);
        } else {
            FontData fd = font.getFontData()[0];
            fd.setHeight((int)((double)fd.getHeight() * zoom));
            this.scaledFont = new Font(null, fd);
            control.setFont(this.scaledFont);
        }
    }

    private void disposeScaledFont() {
        if (this.scaledFont != null) {
            this.scaledFont.dispose();
            this.scaledFont = null;
        }
    }
}

