/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

final class FeatureSortField
extends SortField {
    private final String featureName;

    public FeatureSortField(String field, String featureName) {
        super(Objects.requireNonNull(field), SortField.Type.CUSTOM, true);
        this.featureName = Objects.requireNonNull(featureName);
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
        return new FeatureComparator(this, numHits, this.getField(), this.featureName);
    }

    @Override
    public void setMissingValue(Object missingValue) {
        throw new IllegalArgumentException("Missing value not supported for FeatureSortField");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.featureName.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureSortField other = (FeatureSortField)obj;
        return Objects.equals(this.featureName, other.featureName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<feature:");
        builder.append('\"');
        builder.append(this.getField());
        builder.append('\"');
        builder.append(" featureName=");
        builder.append(this.featureName);
        builder.append('>');
        return builder.toString();
    }

    class FeatureComparator
    extends SimpleFieldComparator<Float> {
        private final String field;
        private final BytesRef featureName;
        private final float[] values;
        private float bottom;
        private float topValue;
        private PostingsEnum currentReaderPostingsValues;

        public FeatureComparator(FeatureSortField this$0, int numHits, String field, String featureName) {
            this.values = new float[numHits];
            this.field = field;
            this.featureName = new BytesRef(featureName);
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            Terms terms = Terms.getTerms(context.reader(), this.field);
            TermsEnum termsEnum = terms.iterator();
            this.currentReaderPostingsValues = termsEnum.seekExact(this.featureName) ? termsEnum.postings(this.currentReaderPostingsValues, 8) : null;
        }

        private float getValueForDoc(int doc) throws IOException {
            if (this.currentReaderPostingsValues != null && doc >= this.currentReaderPostingsValues.docID() && (this.currentReaderPostingsValues.docID() == doc || this.currentReaderPostingsValues.advance(doc) == doc)) {
                return FeatureField.decodeFeatureValue(this.currentReaderPostingsValues.freq());
            }
            return 0.0f;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Float.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Float.compare(this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.getValueForDoc(doc);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Float value) {
            this.topValue = value.floatValue();
        }

        @Override
        public Float value(int slot) {
            return Float.valueOf(this.values[slot]);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Float.compare(this.topValue, this.getValueForDoc(doc));
        }
    }
}

