/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;

public final class TextualAnnotationStyles {
    public static StyledString.Styler getAnnotationStyle(Set<GraphicalAnnotation> annotations) {
        return TextualAnnotationStyles.getAnnotationStyle(annotations, annotation -> true);
    }

    public static StyledString.Styler getAnnotationStyle(Set<GraphicalAnnotation> annotations, Predicate<GraphicalAnnotation> filter) {
        return annotations.stream().filter(filter).map(TextualAnnotationStyles::lookupAnnotationPreference).filter(TextualAnnotationStyles::isEnabled).filter(TextualAnnotationStyles::hasTextStylePreference).filter(TextualAnnotationStyles::hasColorPreference).max(Comparator.comparingInt(AnnotationPreference::getPresentationLayer)).map(TextualAnnotationStyles::createStyler).orElse(null);
    }

    private static AnnotationPreference lookupAnnotationPreference(GraphicalAnnotation annotation) {
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation.getType());
    }

    private static boolean hasColorPreference(AnnotationPreference preference) {
        return preference.getColorPreferenceKey() != null || preference.getColorPreferenceValue() != null;
    }

    private static boolean hasTextStylePreference(AnnotationPreference preference) {
        return preference.getTextStylePreferenceKey() != null || preference.getTextStyleValue() != null;
    }

    private static boolean isEnabled(AnnotationPreference preference) {
        String key = preference.getTextPreferenceKey();
        if (key != null) {
            return EditorsUI.getPreferenceStore().getBoolean(key);
        }
        return preference.getTextPreferenceValue();
    }

    private static String getTextStyle(AnnotationPreference preference) {
        String value;
        String key = preference.getTextStylePreferenceKey();
        if (key != null && (value = EditorsUI.getPreferenceStore().getString(key)) != null) {
            return value;
        }
        return preference.getTextStyleValue();
    }

    private static Color getColor(AnnotationPreference preference) {
        RGB value;
        String key = preference.getColorPreferenceKey();
        if (key != null && (value = PreferenceConverter.getColor((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)key)) != null) {
            return EditorsUI.getSharedTextColors().getColor(value);
        }
        return EditorsUI.getSharedTextColors().getColor(preference.getColorPreferenceValue());
    }

    private static StyledString.Styler createStyler(AnnotationPreference preference) {
        String style = TextualAnnotationStyles.getTextStyle(preference);
        if (style == null) {
            return null;
        }
        Color color = TextualAnnotationStyles.getColor(preference);
        if (color == null) {
            return null;
        }
        return TextualAnnotationStyles.createStyler(style, color);
    }

    private static StyledString.Styler createStyler(String style, Color color) {
        return switch (style) {
            case "SQUIGGLES" -> new UnderlineStyler(3, color);
            case "PROBLEM_UNDERLINE" -> new UnderlineStyler(2, color);
            case "BOX" -> new BoxStyler(1, color);
            case "DASHED_BOX" -> new BoxStyler(2, color);
            case "UNDERLINE" -> new UnderlineStyler(0, color);
            default -> null;
        };
    }

    private TextualAnnotationStyles() {
        throw new UnsupportedOperationException();
    }

    public static final class BoxStyler
    extends StyledString.Styler {
        private final int style;
        private final Color borderColor;

        public BoxStyler(int style, Color borderColor) {
            this.style = style;
            this.borderColor = borderColor;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.borderStyle = this.style;
            textStyle.borderColor = this.borderColor;
        }
    }

    public static class UnderlineStyler
    extends StyledString.Styler {
        private final int style;
        private final Color underlineColor;

        private UnderlineStyler(int style, Color underlineColor) {
            this.style = style;
            this.underlineColor = underlineColor;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.underline = true;
            textStyle.underlineColor = this.underlineColor;
            textStyle.underlineStyle = this.style;
        }
    }
}

