/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class GraphicalViewerAnnotationModelEventDispatcher
extends UIJob {
    private final GraphicalViewer viewer;
    private final GraphicalAnnotationModel annotationModel;
    private final DispatcherGraphicalAnnotationModelListener annotationModelListener = new DispatcherGraphicalAnnotationModelListener();
    private final BlockingQueue<GraphicalAnnotationModelEvent> queue = new LinkedBlockingQueue<GraphicalAnnotationModelEvent>();

    public GraphicalViewerAnnotationModelEventDispatcher(String name, GraphicalViewer viewer, GraphicalAnnotationModel annotationModel) {
        super(MessageFormat.format(Messages.GraphicalViewerAnnotationModelEventDispatcher_Name, name));
        this.annotationModel = Objects.requireNonNull(annotationModel);
        this.viewer = Objects.requireNonNull(viewer);
        this.annotationModelListener.install(annotationModel);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        ArrayList<GraphicalAnnotationModelEvent> queued = new ArrayList<GraphicalAnnotationModelEvent>();
        this.queue.drainTo(queued);
        try {
            this.dispatch(queued, GraphicalViewerAnnotationModelEventDispatcher.monitorFor(monitor));
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        IProgressService progressService;
        if (PlatformUI.isWorkbenchRunning() && (progressService = PlatformUI.getWorkbench().getProgressService()) instanceof ProgressProvider) {
            ProgressProvider progressProvider = (ProgressProvider)progressService;
            return progressProvider.monitorFor(monitor);
        }
        return IProgressMonitor.nullSafe((IProgressMonitor)monitor);
    }

    protected void dispatch(List<GraphicalAnnotationModelEvent> events, IProgressMonitor monitor) {
        for (GraphicalAnnotationModelEvent event : events) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.dispatch(event, monitor);
        }
    }

    protected void dispatch(GraphicalAnnotationModelEvent event, IProgressMonitor monitor) {
        for (Object target : event.getTargets()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.dispatch(target, event);
        }
    }

    protected void dispatch(Object target, GraphicalAnnotationModelEvent event) {
        AnnotableGraphicalEditPart editPart = this.findEditPart(target);
        if (editPart != null) {
            editPart.updateAnnotations(event);
        }
    }

    protected AnnotableGraphicalEditPart findEditPart(Object target) {
        EditPart editPart;
        if (target != null && (editPart = this.viewer.getEditPartForModel(target)) instanceof AnnotableGraphicalEditPart) {
            AnnotableGraphicalEditPart editPart2 = (AnnotableGraphicalEditPart)editPart;
            return editPart2;
        }
        return null;
    }

    public void dispose() {
        this.annotationModelListener.uninstall(this.annotationModel);
        this.queue.clear();
        this.cancel();
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    private void handleEvent(GraphicalAnnotationModelEvent event) {
        this.queue.add(event);
        this.schedule();
    }

    protected class DispatcherGraphicalAnnotationModelListener
    implements GraphicalAnnotationModelListener {
        protected DispatcherGraphicalAnnotationModelListener() {
        }

        @Override
        public void modelChanged(GraphicalAnnotationModelEvent event) {
            GraphicalViewerAnnotationModelEventDispatcher.this.handleEvent(event);
        }

        public void install(GraphicalAnnotationModel annotationModel) {
            annotationModel.addAnnotationModelListener(this, true);
        }

        public void uninstall(GraphicalAnnotationModel annotationModel) {
            annotationModel.removeAnnotationModelListener(this);
        }
    }
}

