/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;

public class HidePinCommand
extends Command
implements ScopedCommand {
    private final IInterfaceElement interfaceElement;
    private final boolean visible;

    public HidePinCommand(IInterfaceElement interfaceElement, boolean visible) {
        this.interfaceElement = Objects.requireNonNull(interfaceElement);
        this.visible = visible;
    }

    public void execute() {
        this.interfaceElement.setVisible(this.visible);
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.interfaceElement.setVisible(!this.visible);
    }

    public boolean canExecute() {
        if (!this.visible && HidePinCommand.isConnectedInsideSubApp(this.interfaceElement)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.HidePinCommand_PinCannotBeHidden_ConnectedInside);
            return false;
        }
        return (this.interfaceElement instanceof VarDeclaration || this.interfaceElement instanceof AdapterDeclaration) && (this.interfaceElement.isIsInput() && this.interfaceElement.getInputConnections().isEmpty() || !this.interfaceElement.isIsInput() && this.interfaceElement.getOutputConnections().isEmpty()) && !HidePinCommand.isExpandedSubAppPinAndConnected(this.interfaceElement);
    }

    protected static boolean isExpandedSubAppPinAndConnected(IInterfaceElement interfaceElement) {
        SubApp subApp;
        BlockFBNetworkElement blockFBNetworkElement = interfaceElement.getBlockFBNetworkElement();
        return blockFBNetworkElement instanceof SubApp && (subApp = (SubApp)blockFBNetworkElement).isUnfolded() && !interfaceElement.getInputConnections().isEmpty() && !interfaceElement.getOutputConnections().isEmpty();
    }

    private static boolean isConnectedInsideSubApp(IInterfaceElement element) {
        if (element instanceof VarDeclaration) {
            EObject eObject;
            VarDeclaration varDecl = (VarDeclaration)element;
            if (element.isIsInput() && (eObject = element.eContainer().eContainer()) instanceof SubAppType) {
                SubAppType sat = (SubAppType)eObject;
                String name = varDecl.getName();
                return sat.getFBNetwork().getBlockFBNetworkElements().anyMatch(fb -> {
                    IInterfaceElement internal = fb.getInterfaceElement(name);
                    return internal != null && !internal.getInputConnections().isEmpty();
                });
            }
        }
        return false;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.interfaceElement);
    }
}

