/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.dataexport.AbstractBlockTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;

public class FCTExporter
extends AbstractBlockTypeExporter {
    public FCTExporter(FunctionFBType type) {
        super(type);
    }

    @Override
    protected String getRootTag() {
        return "Function";
    }

    @Override
    protected void createBlockTypeSpecificXMLEntries() throws XMLStreamException {
        this.addFunctionBody(this.getType().getBody());
    }

    private void addFunctionBody(FunctionBody body) throws XMLStreamException {
        if (body == null) {
            return;
        }
        this.addStartElement("FunctionBody");
        if (body instanceof STFunctionBody) {
            STFunctionBody stFunctionBody = (STFunctionBody)body;
            this.addSTFunctionBody(stFunctionBody);
        }
        this.addEndElement();
    }

    private void addSTFunctionBody(STFunctionBody body) throws XMLStreamException {
        this.addStartElement("ST");
        this.writeFunctionBodyText(body.getText());
        this.addInlineEndElement();
    }

    private void writeFunctionBodyText(String text) throws XMLStreamException {
        if (text != null) {
            this.writeCDataSection(text);
        } else {
            this.getWriter().writeCharacters("");
        }
    }

    @Override
    public FunctionFBType getType() {
        return (FunctionFBType)super.getType();
    }
}

