/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoLibraryConnectorsRegistry;
import org.eclipse.acceleo.common.internal.utils.AcceleoLibrariesEclipseUtil;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.common.internal.utils.AcceleoServicesEclipseUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanionProvider;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanionsRegistry;
import org.eclipse.acceleo.common.library.connector.ILibrary;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;

public class AcceleoCommonPlugin
extends Plugin {
    public static final String LIBRARIES_EXTENSION_POINT = "org.eclipse.acceleo.common.libraries";
    public static final String COMPANIONS_EXTENSION_POINT = "org.eclipse.acceleo.common.internal.classloadingcompanion";
    public static final String LIBRARY_CONNECTORS_EXTENSION_POINT = "org.eclipse.acceleo.common.library.connectors";
    public static final String PLUGIN_ID = "org.eclipse.acceleo.common";
    @Deprecated
    public static final String SERVICES_EXTENSION_POINT = "org.eclipse.acceleo.common.java.services";
    private static final String CLASS_TAG_NAME = "class";
    private static final String FILE_EXTENSION_TAG_NAME = "fileExtension";
    private static final String FILE_TAG_NAME = "file";
    private static AcceleoCommonPlugin plugin;
    private BundleContext context;
    private final AcceleoLibraryConnectorsRegistryListener librariesConnectorListener = new AcceleoLibraryConnectorsRegistryListener();
    private final AcceleoCompanionsRegistryListener companionsListener = new AcceleoCompanionsRegistryListener();
    private final AcceleoLibrariesRegistryListener librariesListener = new AcceleoLibrariesRegistryListener();

    public AcceleoCommonPlugin() {
        plugin = this;
    }

    public static AcceleoCommonPlugin getDefault() {
        return plugin;
    }

    @Deprecated
    public static void log(Exception e, boolean blocker) {
        AcceleoLogger.log(e, blocker);
    }

    @Deprecated
    public static void log(IStatus status) {
        AcceleoLogger.log(status);
    }

    @Deprecated
    public static void log(String message, boolean blocker) {
        AcceleoLogger.log(message, blocker);
    }

    @Deprecated
    public static void log(String message, Exception cause, boolean blocker) {
        AcceleoLogger.log(message, cause, blocker);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        AcceleoWorkspaceUtil.INSTANCE.initialize();
        this.context = bundleContext;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this.librariesConnectorListener, LIBRARY_CONNECTORS_EXTENSION_POINT);
        registry.addListener((IRegistryEventListener)this.librariesListener, LIBRARIES_EXTENSION_POINT);
        registry.addListener((IRegistryEventListener)this.companionsListener, COMPANIONS_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.librariesConnectorListener);
            registry.removeListener((IRegistryEventListener)this.librariesListener);
            registry.removeListener((IRegistryEventListener)this.companionsListener);
            AcceleoServicesEclipseUtil.clearRegistry();
            AcceleoLibraryConnectorsRegistry.INSTANCE.clearRegistry();
            AcceleoLibrariesEclipseUtil.clearRegistry();
            ClassLoadingCompanionsRegistry.INSTANCE.clearRegistry();
            AcceleoWorkspaceUtil.INSTANCE.dispose();
            AcceleoPreferences.save();
            plugin = null;
            this.context = null;
        }
        finally {
            super.stop(bundleContext);
        }
    }

    private void parseInitialContributions() {
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(LIBRARY_CONNECTORS_EXTENSION_POINT).getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement service = iConfigurationElementArray[n];
                try {
                    AcceleoLibraryConnectorsRegistry.INSTANCE.addLibraryConnector(service.createExecutableExtension(CLASS_TAG_NAME).getClass(), service.getAttribute(FILE_EXTENSION_TAG_NAME));
                }
                catch (CoreException e) {
                    AcceleoLogger.log((Exception)((Object)e), false);
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = registry.getExtensionPoint(LIBRARIES_EXTENSION_POINT).getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement library = iConfigurationElementArray[n];
                String pathToFile = library.getAttribute(FILE_TAG_NAME);
                Class<ILibrary> libClass = AcceleoLibraryConnectorsRegistry.INSTANCE.getConnectorForResource(pathToFile);
                if (libClass != null) {
                    try {
                        ILibrary lib = libClass.newInstance();
                        lib.setURI(URI.createFileURI((String)ResourcesPlugin.getWorkspace().getRoot().getProject(extension.getContributor().getName()).getFile(pathToFile).getLocation().toString()));
                        AcceleoLibrariesEclipseUtil.addLibrary(lib);
                    }
                    catch (InstantiationException e) {
                        AcceleoLogger.log(e, true);
                    }
                    catch (IllegalAccessException e) {
                        AcceleoLogger.log(e, true);
                    }
                } else {
                    AcceleoLogger.log(AcceleoCommonMessages.getString("AcceleoLogger.MissingHandle", pathToFile), false);
                }
                ++n;
            }
            ++n4;
        }
    }

    final class AcceleoCompanionsRegistryListener
    implements IRegistryEventListener {
        AcceleoCompanionsRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    try {
                        ClassLoadingCompanionsRegistry.INSTANCE.register((ClassLoadingCompanionProvider)service.createExecutableExtension(AcceleoCommonPlugin.CLASS_TAG_NAME));
                    }
                    catch (CoreException e) {
                        AcceleoCommonPlugin.log((Exception)((Object)e), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    ClassLoadingCompanionsRegistry.INSTANCE.unregister(service.getAttribute(AcceleoCommonPlugin.CLASS_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }

    final class AcceleoLibrariesRegistryListener
    implements IRegistryEventListener {
        AcceleoLibrariesRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    String pathToFile = service.getAttribute(AcceleoCommonPlugin.FILE_TAG_NAME);
                    Class<ILibrary> libClass = AcceleoLibraryConnectorsRegistry.INSTANCE.getConnectorForResource(pathToFile);
                    if (libClass != null) {
                        try {
                            ILibrary lib = libClass.newInstance();
                            lib.setURI(URI.createFileURI((String)ResourcesPlugin.getWorkspace().getRoot().getProject(extension.getContributor().getName()).getFile(pathToFile).getLocation().toString()));
                            AcceleoLibrariesEclipseUtil.addLibrary(lib);
                        }
                        catch (InstantiationException e) {
                            AcceleoLogger.log(e, true);
                        }
                        catch (IllegalAccessException e) {
                            AcceleoLogger.log(e, true);
                        }
                    } else {
                        AcceleoLogger.log(AcceleoCommonMessages.getString("AcceleoLogger.MissingHandle", pathToFile), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    AcceleoLibrariesEclipseUtil.removeLibrary(service.getAttribute(AcceleoCommonPlugin.FILE_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }

    final class AcceleoLibraryConnectorsRegistryListener
    implements IRegistryEventListener {
        AcceleoLibraryConnectorsRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    try {
                        AcceleoLibraryConnectorsRegistry.INSTANCE.addLibraryConnector(service.createExecutableExtension(AcceleoCommonPlugin.CLASS_TAG_NAME).getClass(), service.getAttribute(AcceleoCommonPlugin.FILE_EXTENSION_TAG_NAME));
                    }
                    catch (CoreException e) {
                        AcceleoLogger.log((Exception)((Object)e), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    AcceleoLibraryConnectorsRegistry.INSTANCE.removeLibraryConnector(service.getAttribute(AcceleoCommonPlugin.CLASS_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }
}

