/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorConditional;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorFeatureAccessOrCall;
import org.eclipse.acceleo.query.ast.ErrorStringLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.completion.TextCompletionProposal;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SetType;

public class AstCompletor
extends AstSwitch<List<ICompletionProposal>> {
    private static final String SPACE = " ";
    private final CompletionServices services;
    private List<String> variableNames;
    private IValidationResult validationResult;

    public AstCompletor(CompletionServices services) {
        this.services = services;
    }

    public List<ICompletionProposal> getProposals(Set<String> varNames, IValidationResult validationRes) {
        List result;
        this.validationResult = validationRes;
        this.variableNames = new ArrayList<String>(varNames);
        List<Error> errors = validationRes.getAstResult().getErrors();
        if (errors.size() > 0) {
            this.completeVariablesNames(errors.get(0));
            result = (List)this.doSwitch(errors.get(0));
        } else {
            Set<IType> possibleTypes = this.validationResult.getPossibleTypes(this.validationResult.getAstResult().getAst());
            result = this.getExpressionTextFollows(possibleTypes);
        }
        return result;
    }

    private void completeVariablesNames(Expression exp) {
        Expression current = exp;
        while (current != null) {
            if (current instanceof Let) {
                Let let = (Let)current;
                for (Binding binding : let.getBindings()) {
                    if (binding.getName() == null) continue;
                    this.variableNames.add(binding.getName());
                }
            } else if (current instanceof Lambda) {
                Lambda lambda = (Lambda)current;
                for (VariableDeclaration declaration : lambda.getParameters()) {
                    if (declaration.getName() == null) continue;
                    this.variableNames.add(declaration.getName());
                }
            }
            current = current.eContainer() instanceof Expression ? (Expression)current.eContainer() : null;
        }
        Collections.sort(this.variableNames);
    }

    @Override
    public List<ICompletionProposal> caseErrorExpression(ErrorExpression object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.getExpressionProposals());
        return result;
    }

    private List<ICompletionProposal> getExpressionProposals() {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.getExpressionTextPrefixes());
        result.addAll(this.services.getVariableProposals(this.variableNames));
        result.addAll(this.services.getEClassifierProposals());
        result.addAll(this.services.getEEnumLiteralProposals());
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorFeatureAccessOrCall(ErrorFeatureAccessOrCall object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        Set<IType> possibleTypes = this.validationResult.getPossibleTypes(object.getTarget());
        result.addAll(this.services.getEStructuralFeatureProposals(possibleTypes));
        result.addAll(this.services.getServiceProposals(possibleTypes, CallType.CALLORAPPLY));
        result.addAll(this.services.getEOperationProposals(possibleTypes));
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorTypeLiteral(ErrorTypeLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getSegments().size() == 0) {
            result.addAll(this.services.getEClassifierProposals());
            result.addAll(this.services.getEEnumLiteralProposals());
        } else if (object.getSegments().size() == 1) {
            result.addAll(this.services.getEClassifierProposals((String)object.getSegments().get(0)));
            result.addAll(this.services.getEEnumLiteralProposals((String)object.getSegments().get(0)));
        } else if (object.getSegments().size() == 2) {
            result.addAll(this.services.getEEnumLiteralProposals((String)object.getSegments().get(0), (String)object.getSegments().get(1)));
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorEnumLiteral(ErrorEnumLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.services.getEEnumLiteralProposals((String)object.getSegments().get(0), (String)object.getSegments().get(1)));
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorCall(ErrorCall object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (!object.isMissingEndParenthesis()) {
            LinkedHashSet<IType> collectionTypes = new LinkedHashSet<IType>();
            Set<IType> possibleReceiverTypes = this.validationResult.getPossibleTypes((Expression)object.getArguments().get(0));
            if (possibleReceiverTypes.isEmpty()) {
                collectionTypes.add(new SetType(this.services.getQueryEnvironment(), new NothingType("Argument collection will be empty for call to " + object.getServiceName())));
            } else {
                for (IType type : possibleReceiverTypes) {
                    if (type instanceof ICollectionType) {
                        collectionTypes.add(type);
                        continue;
                    }
                    collectionTypes.add(new SetType(this.services.getQueryEnvironment(), type));
                }
            }
            result.addAll(this.services.getServiceProposals(collectionTypes, object.getType()));
        } else {
            if (object.getArguments().size() == 1) {
                result.addAll(this.getExpressionProposals());
            } else {
                Expression firstArg = (Expression)object.getArguments().get(1);
                if (firstArg instanceof Lambda) {
                    Lambda lambda = (Lambda)firstArg;
                    result.addAll(this.getExpressionTextFollows(this.validationResult.getPossibleTypes(lambda.getExpression())));
                } else {
                    result.add(new TextCompletionProposal(", ", 0));
                }
            }
            result.add(new TextCompletionProposal(")", 0));
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorVariableDeclaration(ErrorVariableDeclaration object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getName() == null) {
            result.addAll(this.services.getVariableDeclarationProposals(this.validationResult.getPossibleTypes(object.getExpression())));
        } else if (object.getType() == null) {
            result.add(new TextCompletionProposal(" : ", 0));
            result.add(new TextCompletionProposal(" | ", 0));
        } else if (object.getType() instanceof ErrorTypeLiteral) {
            result.addAll((Collection)this.doSwitch(object.getType()));
        } else {
            result.add(new TextCompletionProposal(" | ", 0));
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorStringLiteral(ErrorStringLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorBinding(ErrorBinding object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getName() != null) {
            if (object.getType() instanceof ErrorTypeLiteral) {
                result.addAll((Collection)this.doSwitch(object.getType()));
            } else {
                if (object.getType() == null) {
                    result.add(new TextCompletionProposal(" : ", 0));
                }
                if (object.getValue() == null) {
                    result.add(new TextCompletionProposal(" = ", 0));
                }
                if (object.getValue() instanceof ErrorExpression) {
                    result.addAll((Collection)this.doSwitch(object.getValue()));
                }
            }
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorConditional(ErrorConditional object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getFalseBranch() != null) {
            result.add(new TextCompletionProposal("endif ", 0));
        } else if (object.getTrueBranch() != null) {
            result.add(new TextCompletionProposal("else ", 0));
        } else if (object.getPredicate() != null) {
            result.add(new TextCompletionProposal("then ", 0));
        }
        return result;
    }

    public List<ICompletionProposal> getExpressionTextPrefixes() {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add(new TextCompletionProposal("not ", 0));
        result.add(new TextCompletionProposal("- ", 0));
        result.add(new TextCompletionProposal("()", 1));
        result.add(new TextCompletionProposal("true", 0));
        result.add(new TextCompletionProposal("false", 0));
        result.add(new TextCompletionProposal("null", 0));
        result.add(new TextCompletionProposal("{}", 1));
        result.add(new TextCompletionProposal("Sequence{}", 1));
        result.add(new TextCompletionProposal("OrderedSet{}", 1));
        result.add(new TextCompletionProposal("let ", 0));
        result.add(new TextCompletionProposal("if ", 0));
        return result;
    }

    private List<ICompletionProposal> getExpressionTextFollows(Set<IType> possibleTypes) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<IServiceCompletionProposal> servicesProposal = this.services.getServiceProposals(possibleTypes, null);
        HashSet<String> serviceNames = new HashSet<String>();
        for (IServiceCompletionProposal proposal : servicesProposal) {
            serviceNames.add(proposal.getObject().getName());
        }
        if (serviceNames.contains("add")) {
            result.add(new TextCompletionProposal("+ ", 0));
        }
        if (serviceNames.contains("sub")) {
            result.add(new TextCompletionProposal("- ", 0));
        }
        if (serviceNames.contains("lessThanEqual")) {
            result.add(new TextCompletionProposal("<= ", 0));
        }
        if (serviceNames.contains("greaterThanEqual")) {
            result.add(new TextCompletionProposal(">= ", 0));
        }
        if (serviceNames.contains("differs")) {
            result.add(new TextCompletionProposal("<> ", 0));
        }
        if (serviceNames.contains("equals")) {
            result.add(new TextCompletionProposal("= ", 0));
        }
        if (serviceNames.contains("lessThan")) {
            result.add(new TextCompletionProposal("< ", 0));
        }
        if (serviceNames.contains("greaterThan")) {
            result.add(new TextCompletionProposal("> ", 0));
        }
        if (serviceNames.contains("mult")) {
            result.add(new TextCompletionProposal("* ", 0));
        }
        if (serviceNames.contains("divOp")) {
            result.add(new TextCompletionProposal("/ ", 0));
        }
        if (serviceNames.contains("and")) {
            result.add(new TextCompletionProposal("and ", 0));
        }
        if (serviceNames.contains("or")) {
            result.add(new TextCompletionProposal("or ", 0));
        }
        if (serviceNames.contains("xor")) {
            result.add(new TextCompletionProposal("xor ", 0));
        }
        if (serviceNames.contains("implies")) {
            result.add(new TextCompletionProposal("implies ", 0));
        }
        return result;
    }
}

