/*******************************************************************************
 * Copyright (c) 2015 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2015 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.acceleo.query.runtime.impl;

import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;

/**
 * Abstract implementation of the language services.
 * 
 * @author <a href="mailto:yvan.lussaud@obeo.fr">Yvan Lussaud</a>
 */
public abstract class AbstractLanguageServices {

	/**
	 * Log message used when accessing a feature on a JavaObject.
	 */
	protected static final String NON_EOBJECT_FEATURE_ACCESS = "Attempt to access feature (%s) on a non ModelObject value (%s).";

	/**
	 * Log message used when a called service was not found.
	 */
	protected static final String SERVICE_NOT_FOUND = "Couldn't find the %s service";

	/**
	 * Log message used when a called service or EOperation was not found.
	 */
	protected static final String SERVICE_EOPERATION_NOT_FOUND = "Couldn't find the %s service or EOperation";

	/**
	 * Log message used when a called EOperation can't be invoked.
	 */
	protected static final String COULDN_T_INVOKE_EOPERATION = "Couldn't invoke the %s EOperation (%s)";

	/**
	 * Log message used when a requested variable was not found.
	 */
	protected static final String VARIABLE_NOT_FOUND = "Couldn't find the %s variable";

	/**
	 * Log message used when accessing an unknown feature.
	 */
	protected static final String UNKNOWN_FEATURE = "Feature %s not found in EClass %s";

	/**
	 * The {@link IReadOnlyQueryEnvironment}.
	 */
	protected final IReadOnlyQueryEnvironment queryEnvironment;

	/**
	 * Creates a new service instance given a {@link IReadOnlyQueryEnvironment} and logging flag.
	 * 
	 * @param queryEnvironment
	 *            the {@link IReadOnlyQueryEnvironment} to use
	 */
	public AbstractLanguageServices(IReadOnlyQueryEnvironment queryEnvironment) {
		this.queryEnvironment = queryEnvironment;
	}

	/**
	 * Gets the {@link IReadOnlyQueryEnvironment}.
	 * 
	 * @return the queryEnvironment the {@link IReadOnlyQueryEnvironment}
	 */
	public IReadOnlyQueryEnvironment getQueryEnvironment() {
		return queryEnvironment;
	}

}
