/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.parser.AstCompletor;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IQueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.validation.type.IType;

public class QueryCompletionEngine
implements IQueryCompletionEngine {
    private static final String COLON = ":";
    private IReadOnlyQueryEnvironment queryEnvironment;

    public QueryCompletionEngine(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    public ICompletionResult getCompletion(String expression, int offset, Map<String, Set<IType>> variableTypes) {
        AstCompletor completor = new AstCompletor(new CompletionServices(this.queryEnvironment));
        if (offset < 0 || expression != null && offset > expression.length()) {
            throw new IllegalArgumentException("offset (" + offset + ") must be in the range of the given expression: \"" + expression + "\"");
        }
        String prefix = this.getPrefix(expression, offset);
        String remaining = this.getRemaining(expression, offset);
        String toParse = this.getToParse(expression, offset, prefix);
        QueryValidationEngine builder = new QueryValidationEngine(this.queryEnvironment);
        IValidationResult validationResult = builder.validate(toParse, variableTypes);
        CompletionResult result = new CompletionResult(completor.getProposals(variableTypes.keySet(), validationResult));
        result.setPrefix(prefix);
        result.setRemaining(remaining);
        if (prefix != null) {
            result.setReplacementOffset(offset - prefix.length());
            result.setReplacementLength(prefix.length());
        }
        return result;
    }

    private String getPrefix(String expression, int offset) {
        String result;
        if (expression == null) {
            result = null;
        } else {
            String[] splited;
            String prefix;
            int start = offset;
            while (start - 1 >= 0) {
                char charAt = expression.charAt(start - 1);
                if (!Character.isLetter(charAt) && !Character.isDigit(charAt) && charAt != '_' && charAt != ':') break;
                --start;
            }
            result = COLON.equals(prefix = expression.substring(start, offset)) ? "" : (!prefix.endsWith(COLON) ? ((splited = prefix.split("::")).length == 2 ? (!this.queryEnvironment.getEPackageProvider().getTypes(splited[0], splited[1]).isEmpty() ? "" : prefix) : (splited.length == 3 ? (!this.queryEnvironment.getEPackageProvider().getEnumLiterals(splited[0], splited[1], splited[2]).isEmpty() ? "" : prefix) : prefix)) : prefix);
        }
        return result;
    }

    private String getRemaining(String expression, int offset) {
        String result;
        if (expression == null) {
            result = null;
        } else {
            int length = expression.length();
            int end = offset;
            while (end < length) {
                char charAt = expression.charAt(end);
                if (!Character.isLetter(charAt) && !Character.isDigit(charAt) && charAt != '_') break;
                ++end;
            }
            result = expression.substring(offset, end);
        }
        return result;
    }

    private String getToParse(String expression, int offset, String prefix) {
        String result = expression == null ? null : (prefix.contains(COLON) ? expression.substring(0, expression.lastIndexOf(COLON) + 1) : expression.substring(0, offset - prefix.length()));
        return result;
    }
}

