/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.module.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.ide.evaluation.strategy.AcceleoWorkspaceWriterFactory;
import org.eclipse.acceleo.aql.ide.ui.Activator;
import org.eclipse.acceleo.aql.ide.ui.module.main.AbstractGenerator;
import org.eclipse.acceleo.aql.ide.ui.module.services.Services;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class StandaloneGenerator
extends AbstractGenerator {
    private final IFile moduleFile;
    protected String modelModuleQualifiedName;
    protected Module modelModule;
    protected Set<String> dependencyBundleNames;

    public StandaloneGenerator(IFile moduleFile) {
        this.moduleFile = moduleFile;
    }

    private static void registerEPackage(IQualifiedNameQueryEnvironment environment, EPackage ePackage) {
        environment.registerEPackage(ePackage);
        for (EPackage child : ePackage.getESubpackages()) {
            StandaloneGenerator.registerEPackage(environment, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        String moduleQualifiedName = this.getModuleQualifiedName();
        URI targetURI = URI.createFileURI((String)(this.moduleFile.getParent().getLocation().toFile().getAbsolutePath() + "/"));
        Map<String, String> options = this.getOptions();
        ArrayList exceptions = new ArrayList();
        ResourceSetImpl resourceSetForModels = new ResourceSetImpl();
        IQualifiedNameResolver resolver = this.createResolver();
        IQualifiedNameQueryEnvironment queryEnvironment = this.createAcceleoQueryEnvironment(options, resolver, (ResourceSet)resourceSetForModels);
        AcceleoEvaluator evaluator = this.createAcceleoEvaluator(resolver, queryEnvironment);
        IAcceleoGenerationStrategy strategy = this.createGenerationStrategy((ResourceSet)resourceSetForModels);
        Module module = (Module)resolver.resolve(moduleQualifiedName);
        URI logURI = AcceleoUtil.getlogURI((URI)targetURI, (String)options.get("logURI"));
        IQualifiedNameResolver workspaceResolver = QueryPlugin.getPlugin().createQualifiedNameResolver(this.getClass().getClassLoader(), this.moduleFile.getProject(), "::", true);
        java.net.URI binaryURI = workspaceResolver.getBinaryURI(this.moduleFile.getLocation().toFile().toURI());
        workspaceResolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), null));
        this.modelModuleQualifiedName = workspaceResolver.getQualifiedName(binaryURI);
        this.modelModule = (Module)workspaceResolver.resolve(this.modelModuleQualifiedName);
        this.dependencyBundleNames = new LinkedHashSet<String>();
        this.dependencyBundleNames.add("org.eclipse.acceleo.query");
        this.dependencyBundleNames.add("org.eclipse.acceleo.aql");
        this.dependencyBundleNames.addAll(this.getDependencyBundleNames(queryEnvironment, this.modelModule));
        StandaloneGenerator standaloneGenerator = this;
        synchronized (standaloneGenerator) {
            this.beforeGeneration(queryEnvironment, workspaceResolver);
            try {
                AcceleoUtil.generate((AcceleoEvaluator)evaluator, (IQualifiedNameQueryEnvironment)queryEnvironment, (Module)module, (Resource)this.modelModule.eResource(), (IAcceleoGenerationStrategy)strategy, (URI)targetURI, (URI)logURI);
            }
            finally {
                AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
                this.printDiagnostics(evaluator.getGenerationResult());
                this.afterGeneration(evaluator.getGenerationResult());
            }
        }
    }

    protected String getModuleQualifiedName() {
        return "org::eclipse::acceleo::aql::ide::ui::module::main::standalone";
    }

    protected Map<String, String> getOptions() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put("logURI", "acceleo.log");
        res.put("newLine", System.lineSeparator());
        return res;
    }

    protected IQualifiedNameResolver createResolver() {
        ClassLoaderQualifiedNameResolver resolver = new ClassLoaderQualifiedNameResolver(this.getClass().getClassLoader(), "::");
        return resolver;
    }

    protected IQualifiedNameQueryEnvironment createAcceleoQueryEnvironment(Map<String, String> options, IQualifiedNameResolver resolver, ResourceSet resourceSetForModels) {
        IQualifiedNameQueryEnvironment queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)false);
        for (String nsURI : new ArrayList(EPackage.Registry.INSTANCE.keySet())) {
            StandaloneGenerator.registerEPackage(queryEnvironment, EPackage.Registry.INSTANCE.getEPackage(nsURI));
        }
        return queryEnvironment;
    }

    protected AcceleoEvaluator createAcceleoEvaluator(IQualifiedNameResolver resolver, IQualifiedNameQueryEnvironment queryEnvironment) {
        AcceleoEvaluator evaluator = new AcceleoEvaluator(queryEnvironment.getLookupEngine(), System.lineSeparator());
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), evaluator));
        resolver.addLoader((ILoader)new JavaLoader("::", false));
        return evaluator;
    }

    protected IAcceleoGenerationStrategy createGenerationStrategy(ResourceSet resourceSetForModels) {
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(resourceSetForModels.getURIConverter(), (IWriterFactory)new AcceleoWorkspaceWriterFactory());
        return strategy;
    }

    protected void beforeGeneration(IQualifiedNameQueryEnvironment queryEnvironment, IQualifiedNameResolver workspaceResolver) {
        Services.initialize(queryEnvironment, workspaceResolver);
    }

    protected void printDiagnostics(GenerationResult generationResult) {
        if (generationResult.getDiagnostic().getSeverity() > 1) {
            this.printDiagnostic(generationResult.getDiagnostic());
        }
        this.printSummary(generationResult);
    }

    protected void printDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getMessage() != null) {
            Object location = !diagnostic.getData().isEmpty() && diagnostic.getData().get(0) instanceof ASTNode ? AcceleoUtil.getLocation((ASTNode)((ASTNode)diagnostic.getData().get(0))) + ": " : "";
            switch (diagnostic.getSeverity()) {
                case 1: {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 2: {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 4: {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                }
            }
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(child);
        }
    }

    protected void printSummary(GenerationResult result) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        String message = "Files: " + result.getGeneratedFiles().size() + ", Lost Files: " + result.getLostFiles().size() + ", Errors: " + nbErrors + ", Warnings: " + nbWarnings + ", Infos: " + nbInfos + ".";
        Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass(), message));
    }

    protected void afterGeneration(GenerationResult generationResult) {
        Services.initialize(null, null);
        try {
            this.moduleFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            this.addPluginDependencies(this.moduleFile.getProject(), this.dependencyBundleNames);
            String packageName = new Services().getJavaPackage(this.modelModule);
            if (!packageName.isEmpty()) {
                this.addexportPackages(this.moduleFile.getProject(), Collections.singleton(packageName));
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "could not refresh " + String.valueOf(this.moduleFile.getParent().getFullPath()), (Throwable)e));
        }
    }
}

