/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.tests.Setup;
import org.eclipse.acceleo.query.tests.UnitTestModels;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EObjectServicesPerformanceTest {
    private static final int NB_ITERATIONS = 400;
    public static Resource reverseEcoreModel;
    private IQueryEnvironment queryEnvironment;
    private EObjectServices eObjectService;

    @BeforeClass
    public static void loadModel() throws Exception {
        reverseEcoreModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverseEcore();
    }

    @Before
    public void before() throws Exception {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.eObjectService = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, null, null);
    }

    @Test
    public void eAllContentsWithFailingAccessBenchmark() {
        EvaluationResult result;
        Stopwatch noError = Stopwatch.createUnstarted();
        Stopwatch error = Stopwatch.createUnstarted();
        int iterations = 20;
        noError.start();
        int i = 0;
        while (i < iterations) {
            for (EObject root : reverseEcoreModel.getContents()) {
                result = this.eval(root, "self.eAllContents(ecore::EClass)->select(c | not c.abstract)");
                Assert.assertTrue((boolean)(result.getResult() instanceof Collection));
                Assert.assertEquals((long)5219L, (long)((Collection)result.getResult()).size());
            }
            ++i;
        }
        noError.stop();
        error.start();
        i = 0;
        while (i < iterations) {
            for (EObject root : reverseEcoreModel.getContents()) {
                result = this.eval(root, "self.eAllContents()->select(c | not c.abstract)");
                Assert.assertTrue((boolean)(result.getResult() instanceof Collection));
                Assert.assertEquals((long)5219L, (long)((Collection)result.getResult()).size());
            }
            ++i;
        }
        error.stop();
        System.out.println("PERFO: self.eAllContents(ecore::EClass)->select(c | not c.abstract)  :  " + noError.elapsed(TimeUnit.MILLISECONDS) + "ms /  self.eAllContents()->select(c | not c.abstract) : " + error.elapsed(TimeUnit.MILLISECONDS) + "ms");
        double noErrorElapsed = noError.elapsed(TimeUnit.MILLISECONDS);
        double errorElapsed = error.elapsed(TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)("We expect a maximum overhead of 1800% and we had:" + errorElapsed / noErrorElapsed * 100.0 + "%"), (errorElapsed / noErrorElapsed < 18.0 ? 1 : 0) != 0);
    }

    private EvaluationResult eval(EObject root, String expr) {
        QueryBuilderEngine queryBuilder = new QueryBuilderEngine();
        AstResult query = queryBuilder.build(expr);
        QueryEvaluationEngine evaluationEngine = new QueryEvaluationEngine(this.queryEnvironment);
        HashMap<String, EObject> variables = new HashMap<String, EObject>();
        variables.put("self", root);
        EvaluationResult result = evaluationEngine.eval(query, variables);
        return result;
    }

    @Test
    public void eAllContentsBenchmark() {
        Stopwatch emf = Stopwatch.createUnstarted();
        Stopwatch aql = Stopwatch.createUnstarted();
        int i = 0;
        while (i < 400) {
            for (EObject root : reverseEcoreModel.getContents()) {
                emf.start();
                ArrayList ePackagesEMF = Lists.newArrayList((Iterator)Iterators.filter((Iterator)root.eAllContents(), EPackage.class));
                emf.stop();
                aql.start();
                List ePackagesAQL = this.eObjectService.eAllContents(root, EcorePackage.eINSTANCE.getEPackage());
                aql.stop();
                Assert.assertEquals((Object)ePackagesEMF, (Object)ePackagesAQL);
                for (EPackage ePackage : ePackagesEMF) {
                    emf.start();
                    ArrayList eclassesEMF = Lists.newArrayList((Iterator)Iterators.filter((Iterator)ePackage.eAllContents(), EClass.class));
                    emf.stop();
                    aql.start();
                    List eClassesAQL = this.eObjectService.eAllContents((EObject)ePackage, EcorePackage.eINSTANCE.getEClass());
                    aql.stop();
                    Assert.assertEquals((Object)eclassesEMF, (Object)eClassesAQL);
                }
            }
            ++i;
        }
        System.out.println("PERFO: eAllContents(Type)  :  AQL " + aql.elapsed(TimeUnit.MILLISECONDS) + "ms /  EMF : " + emf.elapsed(TimeUnit.MILLISECONDS) + "ms");
        long aqlElapsed = aql.elapsed(TimeUnit.MILLISECONDS);
        long emfElapsed = emf.elapsed(TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"The AQL implementation is supposed to be faster than the EMF one.", (aqlElapsed - emfElapsed < 4000L ? 1 : 0) != 0);
    }

    @Test
    public void eContentsBenchmark() {
        Stopwatch emf = Stopwatch.createUnstarted();
        Stopwatch aql = Stopwatch.createUnstarted();
        int i = 0;
        while (i < 400) {
            for (EObject root : reverseEcoreModel.getContents()) {
                emf.start();
                ArrayList ePackagesEMF = Lists.newArrayList((Iterable)Iterables.filter((Iterable)root.eContents(), EPackage.class));
                emf.stop();
                aql.start();
                List ePackagesAQL = this.eObjectService.eContents(root, EcorePackage.eINSTANCE.getEPackage());
                aql.stop();
                Assert.assertEquals((Object)ePackagesEMF, (Object)ePackagesAQL);
                for (EPackage ePackage : ePackagesEMF) {
                    emf.start();
                    ArrayList eclassesEMF = Lists.newArrayList((Iterable)Iterables.filter((Iterable)ePackage.eContents(), EClass.class));
                    emf.stop();
                    aql.start();
                    List eClassesAQL = this.eObjectService.eContents((EObject)ePackage, EcorePackage.eINSTANCE.getEClass());
                    aql.stop();
                    Assert.assertEquals((Object)eclassesEMF, (Object)eClassesAQL);
                }
            }
            ++i;
        }
        System.out.println("PERFO: eContents(Type)  :  AQL " + aql.elapsed(TimeUnit.MILLISECONDS) + "ms /  EMF : " + emf.elapsed(TimeUnit.MILLISECONDS) + "ms");
        long aqlElapsed = aql.elapsed(TimeUnit.MILLISECONDS);
        long emfElapsed = emf.elapsed(TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"The AQL implementation is supposed to be faster than the EMF one.", (aqlElapsed - emfElapsed < 4000L ? 1 : 0) != 0);
    }
}

