/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage projectPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.projectPage = new WizardNewProjectCreationPage("Specify model name and location.");
        this.addPage((IWizardPage)this.projectPage);
        this.setWindowTitle("Create a new " + this.getProjectTypeName() + " project.");
        this.projectPage.setDescription(this.getWindowTitle());
    }

    public IProject getProject() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.projectPage.getProjectName());
        return project;
    }

    public boolean performFinish() {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectPage.getProjectName());
            projectDescription.setLocation(null);
            this.getProject().create(projectDescription, null);
            ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
            projectDescription.setNatureIds(this.getNatures());
            ArrayList<String> builderIDs = new ArrayList<String>();
            this.addBuilders(builderIDs);
            ICommand[] buildCMDS = new ICommand[builderIDs.size()];
            int i = 0;
            for (String builderID : builderIDs) {
                ICommand build = projectDescription.newCommand();
                build.setBuilderName(builderID);
                buildCMDS[i++] = build;
            }
            projectDescription.setBuildSpec(buildCMDS);
            this.getProject().open(null);
            this.getProject().setDescription(projectDescription, null);
            this.addClasspaths(classpathEntries, this.getProject());
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), null);
            javaProject.setOutputLocation((IPath)new Path("/" + this.projectPage.getProjectName() + "/bin"), null);
            this.createFiles();
            return true;
        }
        catch (Exception exception) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.getPluginID(), "Problem creating " + this.getProjectTypeName() + " project. Ignoring.", (Throwable)exception));
            try {
                this.getProject().delete(true, null);
            }
            catch (Exception exception2) {}
            return false;
        }
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.jdt.core.javanature"};
    }

    public void createFiles() throws CoreException, IOException {
    }

    public String getProjectTypeName() {
        return "Plugin";
    }

    public String getPluginID() {
        return "org.eclipse.amp.escape.ide";
    }

    public void addClasspaths(List<IClasspathEntry> classpathEntries, IProject project) throws CoreException {
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
        IFolder srcFolder = project.getFolder(this.getSourceDirName());
        classpathEntries.add(JavaCore.newSourceEntry((IPath)srcFolder.getFullPath()));
        srcFolder.create(true, true, null);
    }

    public String getSourceDirName() {
        return "src";
    }

    public void addBuilders(List<String> builderIDs) {
        builderIDs.add("org.eclipse.jdt.core.javabuilder");
    }
}

