/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.view;

import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.LifeCycleState;
import org.eclipse.amp.axf.time.TimeGranularity;
import org.eclipse.amp.axf.view.AXFViewPlugin;
import org.eclipse.amp.axf.view.SWTThreadModelListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class SWTAsyncModelListener
extends SWTThreadModelListener {
    private boolean waitForPaint = true;
    private long minTimeBetweenUpdates = 10000L;
    protected boolean updating = false;
    private boolean painting = false;
    private long lastUpdate;

    public SWTAsyncModelListener(Control widget, String name) {
        super(widget, name);
    }

    public SWTAsyncModelListener(Control widget, String name, long updatePeriod) {
        super(widget, name);
        this.minTimeBetweenUpdates = updatePeriod;
    }

    public void stateChange(Object key, Object observed) {
        IModel model = (IModel)observed;
        if (model.getEngine().isRunning() && (System.currentTimeMillis() > this.lastUpdate + this.minTimeBetweenUpdates || model.getPeriod() % ((TimeGranularity)model.getEngine().getUpdateGranularity()).getUpdateFrequency() == 0)) {
            Display display;
            this.lastUpdate = System.currentTimeMillis();
            this.updating = true;
            ReportingRunner runnable = new ReportingRunner((LifeCycleState)key, model);
            if (AXFViewPlugin.getDefault() != null && !(display = AXFViewPlugin.getDefault().getWorkbench().getDisplay()).isDisposed()) {
                display.asyncExec((Runnable)runnable);
                while ((this.updating || this.painting) && this.isWaitForUpdate() && (this.getWidget() == null || !this.getWidget().isDisposed())) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (runnable.t != null) {
                runnable.t.printStackTrace();
            }
        } else if (key == LifeCycleState.OBSERVED || key == LifeCycleState.END) {
            SWTAsyncModelListener.super.stateChange(key, model);
        }
        if (model != null) {
            this.forceModelNotify(model);
        }
    }

    private void doUpdate(Object key, IModel model) {
        if (this.getWidget() == null || !this.getWidget().isDisposed() && this.getWidget().isVisible()) {
            this.update(model);
            this.getListener().stateChange(key, (Object)model);
        }
    }

    public void forceModelNotify(IModel model) {
        model.getEngine().observationComplete((ILifeCycleListener)this);
    }

    public void beginPainting() {
        this.painting = true;
    }

    public void endPainting() {
        this.painting = false;
    }

    public void setWaitForUpdate(boolean waitForPaint) {
        this.waitForPaint = waitForPaint;
    }

    public boolean isWaitForUpdate() {
        return this.waitForPaint;
    }

    private final class ReportingRunner
    implements Runnable {
        private final LifeCycleState key;
        private final IModel model;
        Exception t;

        public ReportingRunner(LifeCycleState key, IModel model) {
            this.key = key;
            this.model = model;
        }

        public void run() {
            try {
                try {
                    SWTAsyncModelListener.this.doUpdate(this.key, this.model);
                }
                catch (Exception e) {
                    this.t = e;
                    SWTAsyncModelListener.this.updating = false;
                    if (this.t != null) {
                        SWTAsyncModelListener.this.painting = false;
                        throw new RuntimeException("Problem in view updating for " + SWTAsyncModelListener.this.getName(), this.t);
                    }
                }
            }
            finally {
                SWTAsyncModelListener.this.updating = false;
                if (this.t != null) {
                    SWTAsyncModelListener.this.painting = false;
                    throw new RuntimeException("Problem in view updating for " + SWTAsyncModelListener.this.getName(), this.t);
                }
            }
        }
    }
}

