/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ascape.model.Agent;
import org.ascape.model.CellOccupant;
import org.ascape.model.HostCell;
import org.ascape.model.LocatedAgent;
import org.ascape.model.rule.Rule;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Node;
import org.ascape.model.space.Relative;
import org.ascape.model.space.Space;
import org.ascape.util.Conditional;

public class Cell
extends LocatedAgent
implements Node {
    private static final long serialVersionUID = 1L;
    public static final Rule PLAY_NEIGHBORS_RULE = new Rule("Play Neighbors"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((CellOccupant)agent).playNeighbors();
        }

        public boolean isRandomExecution() {
            return true;
        }

        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule PLAY_RANDOM_NEIGHBOR_RULE = new Rule("Play Random Neighbor"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((CellOccupant)agent).playRandomNeighbor();
        }

        public boolean isRandomExecution() {
            return true;
        }

        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule CALCULATE_NEIGHBORS_RULE = new Rule("Calculate Neighbors"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((Cell)agent).calculateNeighbors();
        }

        public boolean isRandomExecution() {
            return false;
        }

        public boolean isCauseRemoval() {
            return false;
        }
    };
    protected List neighbors = new ArrayList();
    private List network;

    public void initialize() {
        super.initialize();
        this.network = new ArrayList();
    }

    public void calculateNeighbors() {
        this.setNeighborsList(((Discrete)this.getScape().getSpace()).calculateNeighbors(this));
    }

    public Cell[] getNeighbors() {
        List list = this.findNeighbors();
        Cell[] cells = new Cell[list.size()];
        return list.toArray(cells);
    }

    public List findNeighbors() {
        if (!this.scape.isMutable()) {
            return Collections.unmodifiableList(this.neighbors);
        }
        return ((Discrete)this.getScape().getSpace()).calculateNeighbors(this);
    }

    public Cell findRelative(Coordinate c) throws UnsupportedOperationException {
        Space space = this.getScape().getSpace();
        if (space instanceof Relative) {
            return (Cell)((Relative)((Object)space)).findRelative(this, c);
        }
        throw new UnsupportedOperationException("Cell is not a memeber of a scape space that can handle relative coordiantes: " + space);
    }

    public List getNeighbors(Conditional condition) {
        ArrayList neighborsMatching = new ArrayList();
        if (this.scape.isMutable()) {
            this.neighbors = this.findWithin(1.0);
        }
        int i = 0;
        while (i < this.neighbors.size()) {
            if (condition.meetsCondition(this.neighbors.get(i))) {
                neighborsMatching.add(this.neighbors.get(i));
            }
            ++i;
        }
        return neighborsMatching;
    }

    public int countNeighbors(Conditional condition) {
        if (this.scape.isMutable()) {
            this.neighbors = this.scape.findWithin(1.0);
        }
        int count = 0;
        int i = 0;
        while (i < this.neighbors.size()) {
            if (condition.meetsCondition(this.neighbors.get(i))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void playRandomNeighbor() {
        Cell n = (Cell)this.findRandomNeighbor();
        if (n != null) {
            this.play(n);
        }
    }

    public void playNeighbors() {
        Iterator iterator = this.findNeighbors().iterator();
        while (iterator.hasNext()) {
            this.play((Agent)iterator.next());
        }
    }

    public int getDistance(Cell target) {
        return (int)this.calculateDistance(target);
    }

    public void setNeighborsList(List neighbors) {
        this.neighbors = neighbors;
    }

    public void setNeighbors(Cell[] neighbors) {
        this.setNeighborsList(new ArrayList<Cell>(Arrays.asList(neighbors)));
    }

    public Node findRandomNeighbor() {
        try {
            return (Cell)this.neighbors.get(this.randomToLimit(this.neighbors.size()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("No neighbors when trying to find random neighbor for: " + this);
        }
    }

    public Node findRandomAvailableNeighbor() {
        return this.findRandomNeighbor();
    }

    public Node getOccupant() {
        return null;
    }

    public List getNetwork() {
        return this.network;
    }

    public void setNetwork(List network) {
        this.network = network;
    }

    public boolean isAvailable() {
        return false;
    }

    public void setOccupant(Node occupant) {
        throw new RuntimeException("Only host cells can accept occupants.");
    }

    public void removeOccupant() {
        throw new RuntimeException("You cannot remove an occupant from a Cell, which can not support occupants.");
    }

    public Object clone() {
        Cell clone = (Cell)super.clone();
        clone.coordinate = null;
        return clone;
    }

    public String toString() {
        if (this.getName() != null) {
            if (this.coordinate != null) {
                return String.valueOf(this.getName()) + " " + this.coordinate;
            }
            return this.getName();
        }
        if (this.coordinate != null) {
            return "Cell " + this.coordinate;
        }
        return "Cell";
    }

    protected static Conditional hostedCondition(final Conditional condition) {
        if (condition != null) {
            Conditional hostedCondition = new Conditional(){
                private static final long serialVersionUID = 1L;

                public boolean meetsCondition(Object object) {
                    CellOccupant occupant = (CellOccupant)((HostCell)object).getOccupant();
                    return occupant != null && condition.meetsCondition(occupant);
                }
            };
            return hostedCondition;
        }
        return HostCell.IS_OCCUPIED;
    }

    public static List findOccupants(List candidates) {
        ArrayList<CellOccupant> occupants = new ArrayList<CellOccupant>();
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            CellOccupant cellOccupant = (CellOccupant)((Cell)iterator.next()).getOccupant();
            if (cellOccupant == null) continue;
            occupants.add(cellOccupant);
        }
        return occupants;
    }
}

