/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate1DDiscrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.ListBase;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.model.space.Space;
import org.ascape.model.space.SpaceContext;
import org.ascape.util.Conditional;
import org.ascape.util.Conditionals;
import org.ascape.util.RandomIterator;
import org.ascape.util.ResetableIterator;
import org.ascape.util.data.DataPoint;
import org.ascape.util.data.DataPointConcrete;

public class CollectionSpace
implements Space,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int ESTIMATED_MAXIMUM_SIZE = 100;
    protected Collection collection = new ArrayList();
    private boolean deleteSweepNeeded;
    private SpaceContext context;
    private Random random;
    protected Geometry geometry;
    protected Coordinate extent = new Coordinate1DDiscrete(0);

    public CollectionSpace() {
        this.geometry = new Geometry(1, false, false, true, -3);
    }

    public void deleteSweep() {
        if (this.deleteSweepNeeded) {
            ArrayList<Location> newList = new ArrayList<Location>();
            for (Location candidate : this.collection) {
                if (candidate.isDelete() && this.getContext().isHome(candidate)) continue;
                newList.add(candidate);
            }
            this.collection = newList;
            this.deleteSweepNeeded = false;
        }
    }

    public synchronized Location newLocation() {
        return this.newLocation(false);
    }

    public synchronized Location newLocation(boolean randomLocation) {
        Location newLocation = (Location)this.getContext().getPrototype().clone();
        if (!randomLocation || !(this instanceof ListBase)) {
            this.add(newLocation);
        } else {
            ((ListBase)this).add(this.randomToLimit(this.size()), (Object)newLocation);
        }
        newLocation.initialize();
        return newLocation;
    }

    public boolean isEmpty() {
        this.deleteSweep();
        return this.collection.isEmpty();
    }

    public boolean contains(Object o) {
        if (!(o instanceof Location && ((Location)o).isDelete() && this.getContext().isHome((Location)o))) {
            return this.collection.contains(o);
        }
        return false;
    }

    public Object[] toArray() {
        this.deleteSweep();
        return this.collection.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.deleteSweep();
        return this.collection.toArray(a);
    }

    public boolean containsAll(Collection c) {
        this.deleteSweep();
        return this.containsAll(c);
    }

    public boolean addAll(Collection c) {
        boolean addedAll = this.collection.addAll(c);
        this.setSize(this.getSize() + c.size());
        return addedAll;
    }

    private void clearCoordinates(Collection collection) {
        for (Location a : collection) {
            if (!this.getContext().isHome(a) || !(a instanceof Node)) continue;
            ((Node)a).setCoordinate(null);
        }
    }

    public boolean removeAll(Collection c) {
        this.clearCoordinates(c);
        this.deleteSweep();
        this.setSize(this.collection.size());
        return this.collection.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        for (Location a : this) {
            if (!this.getContext().isHome(a) || !(a instanceof Node) || c.contains(a)) continue;
            ((Node)a).setCoordinate(null);
        }
        boolean retainedAll = this.collection.retainAll(c);
        this.deleteSweep();
        this.setSize(this.collection.size());
        return retainedAll;
    }

    public void clear() {
        this.clearCoordinates(this.collection);
        this.collection = new ArrayList();
        this.setSize(0);
    }

    public boolean add(Object a) {
        return this.add(a, true);
    }

    public boolean add(Object o, boolean isParent) {
        boolean added = false;
        if (isParent && o instanceof Location && ((Location)o).isDelete() && this.getContext().isHome((Location)o)) {
            ((Location)o).clearDeleteMarker();
        } else {
            added = this.collection.add(o);
        }
        this.setSize(this.getSize() + 1);
        return added;
    }

    public boolean remove(Object o) {
        if (o instanceof Location && this.getContext().isHome((Location)o)) {
            this.deleteSweepNeeded = true;
            if (!((Location)o).isDelete()) {
                ((Location)o).markForDeletion();
                if (o instanceof Node) {
                    ((Node)o).setCoordinate(null);
                }
                if (this.collection.contains(o)) {
                    this.setSize(this.getSize() - 1);
                    return true;
                }
                return false;
            }
            return false;
        }
        boolean success = this.collection.remove(o);
        if (success) {
            this.setSize(this.getSize() - 1);
        }
        return success;
    }

    public Iterator iterator() {
        this.deleteSweep();
        return this.collection.iterator();
    }

    public ResetableIterator safeIterator(int start, int limit) {
        if (this.collection instanceof List) {
            if (this.isMutable()) {
                return new MutableSubIterator(start, limit);
            }
            return new SubIterator(start, limit);
        }
        throw new UnsupportedOperationException("The collection must implement list, or the space must provide its own implementation of context iterator.");
    }

    public boolean isMutable() {
        return true;
    }

    public ResetableIterator[] safeIterators(int count) {
        this.deleteSweep();
        int start = 0;
        int increment = this.size() / count;
        ResetableIterator[] iterators = new ResetableIterator[count];
        int i = 0;
        while (i < iterators.length - 1) {
            iterators[i] = this.safeIterator(start, start + increment);
            start += increment;
            ++i;
        }
        iterators[i] = this.safeIterator(start, this.size());
        return iterators;
    }

    public void moveAway(Location origin, Coordinate target, double distance) {
        throw new UnsupportedOperationException("Tried to use move toward within a non-supporting context.");
    }

    public void moveToward(Location origin, Coordinate target, double distance) {
        throw new UnsupportedOperationException("Tried to use move toward within a non-supporting context.");
    }

    public double calculateDistance(Location origin, Location target) {
        return this.calculateDistance(origin.getCoordinate(), target.getCoordinate());
    }

    public double calculateDistance(Coordinate origin, Coordinate target) {
        return origin.getDistance(target);
    }

    public List find(Conditional condition) {
        return CollectionSpace.filter(this, condition);
    }

    public Location findMaximum(Iterator iter, DataPoint dataPoint) {
        ArrayList<Location> multipleMaxObjects = null;
        double maxValue = -1.7976931348623157E308;
        Location maxObject = null;
        while (iter.hasNext()) {
            Object next = iter.next();
            if (dataPoint.getValue(next) > maxValue) {
                maxValue = dataPoint.getValue(next);
                maxObject = (Location)next;
                multipleMaxObjects = null;
                continue;
            }
            if (!DataPointConcrete.equals(dataPoint.getValue(next), maxValue)) continue;
            if (multipleMaxObjects == null) {
                multipleMaxObjects = new ArrayList<Location>();
                multipleMaxObjects.add(maxObject);
            }
            multipleMaxObjects.add((Location)next);
        }
        if (multipleMaxObjects == null) {
            return maxObject;
        }
        return (Location)multipleMaxObjects.get(this.randomToLimit(multipleMaxObjects.size()));
    }

    public Location findNearest(Coordinate origin, Conditional condition, boolean includeOrigin, double distance) {
        return this.findMinimum(this.withinIterator(origin, condition, includeOrigin, distance), new ClosestDataPoint(origin));
    }

    public Location findNearest(Location origin, Conditional condition, boolean includeOrigin, double distance) {
        return this.findNearest(origin.getCoordinate(), condition, includeOrigin, distance);
    }

    public Coordinate findRandomCoordinate() {
        return new Coordinate1DDiscrete(this.randomToLimit(this.collection.size()));
    }

    public static List iteratorToList(Iterator iter) {
        ArrayList l = new ArrayList();
        while (iter.hasNext()) {
            l.add(iter.next());
        }
        return l;
    }

    public static int iteratorCount(Iterator iter) {
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    public List findWithin(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return CollectionSpace.iteratorToList(this.withinIterator(origin, condition, includeSelf, distance));
    }

    public int countWithin(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return CollectionSpace.iteratorCount(this.withinIterator(origin, condition, includeSelf, distance));
    }

    public boolean hasWithin(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return this.withinIterator(origin, condition, includeSelf, distance).hasNext();
    }

    public Location findMinimumWithin(Coordinate coordinate, DataPoint dataPoint, Conditional condition, boolean includeSelf, double distance) {
        return this.findMinimum(this.withinIterator(coordinate, condition, includeSelf, distance), dataPoint);
    }

    public Location findMaximumWithin(Coordinate coordinate, DataPoint dataPoint, Conditional condition, boolean includeSelf, double distance) {
        return this.findMaximum(this.withinIterator(coordinate, condition, includeSelf, distance), dataPoint);
    }

    public Location findMinimum(Iterator iter, DataPoint dataPoint) {
        ArrayList<Location> multipleMinObjects = null;
        double minValue = Double.MAX_VALUE;
        Location minObject = null;
        while (iter.hasNext()) {
            Object next = iter.next();
            if (dataPoint.getValue(next) < minValue) {
                minValue = dataPoint.getValue(next);
                minObject = (Location)next;
                multipleMinObjects = null;
                continue;
            }
            if (!DataPointConcrete.equals(dataPoint.getValue(next), minValue)) continue;
            if (multipleMinObjects == null) {
                multipleMinObjects = new ArrayList<Location>();
                multipleMinObjects.add(minObject);
            }
            multipleMinObjects.add((Location)next);
        }
        if (multipleMinObjects == null) {
            return minObject;
        }
        return (Location)multipleMinObjects.get(this.randomToLimit(multipleMinObjects.size()));
    }

    public ResetableIterator safeIterator() {
        if (this.collection instanceof List) {
            if (this.isMutable()) {
                return new CSMutableIterator();
            }
            return new CSIterator();
        }
        throw new UnsupportedOperationException("The collection must implement list, or the space must provide its own implementation of context iterator.");
    }

    public RandomIterator safeRandomIterator() {
        if (this.collection instanceof List) {
            if (this.isMutable()) {
                return new ListMutableRandomIterator();
            }
            return new ListRandomIterator();
        }
        throw new UnsupportedOperationException("The collection must implement list, or the space must provide its own implementation of context iterator.");
    }

    public static Iterator conditionalIterator(Iterator iter, Conditional condition) {
        return new ConditionalIterator(iter, condition);
    }

    public Iterator conditionalIterator(Conditional condition) {
        return new ConditionalIterator(this.safeIterator(), condition);
    }

    public static List filter(Collection list, Conditional condition) {
        if (condition != null) {
            ArrayList result = new ArrayList();
            for (Object o : list) {
                if (!condition.meetsCondition(o)) continue;
                result.add(o);
            }
            return result;
        }
        return new ArrayList(list);
    }

    public Iterator withinIterator(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        Conditional allConditions = this.createSpatialConditional(origin, condition, includeSelf, distance);
        if (allConditions != null) {
            return CollectionSpace.conditionalIterator(this.iterator(), allConditions);
        }
        return this.iterator();
    }

    protected Conditional createSpatialConditional(final Coordinate origin, Conditional condition, boolean includeSelf, final double distance) {
        Conditional allConditions = null;
        if (distance < Double.MAX_VALUE) {
            allConditions = new Conditional(){
                private static final long serialVersionUID = 1L;

                public boolean meetsCondition(Object o) {
                    return CollectionSpace.this.calculateDistance(origin, ((Location)o).getCoordinate()) <= distance;
                }
            };
        }
        allConditions = Conditionals.and(allConditions, condition);
        if (!includeSelf) {
            allConditions = Conditionals.and(allConditions, new Conditional(){
                private static final long serialVersionUID = 1L;

                public boolean meetsCondition(Object object) {
                    return !((Location)object).getCoordinate().equals(origin);
                }
            });
        }
        return allConditions;
    }

    public Location findRandom() {
        if (this.collection instanceof List) {
            if (this.getSize() > 0) {
                Location candidate;
                while ((candidate = (Location)((List)this.collection).get(this.randomToLimit(this.collection.size()))).isDelete()) {
                }
                return candidate;
            }
            return null;
        }
        throw new UnsupportedOperationException("Can't find random within a bare collection. You must use a list or provide a find random method.");
    }

    public Location findRandom(Location excludeLocation) {
        Location randomLocation;
        while ((randomLocation = this.findRandom()) == excludeLocation) {
        }
        return randomLocation;
    }

    public Location findRandom(Conditional condition) {
        RandomIterator it = this.safeRandomIterator();
        while (it.hasNext()) {
            Object agent = it.next();
            if (!condition.meetsCondition(agent)) continue;
            return (Location)agent;
        }
        return null;
    }

    public Location findRandom(Location exclude, Conditional condition) {
        RandomIterator it = this.safeRandomIterator();
        while (it.hasNext()) {
            Object agent = it.next();
            if (!condition.meetsCondition(agent) || ((Location)agent).getCoordinate() == exclude.getCoordinate()) continue;
            return (Location)agent;
        }
        return null;
    }

    public Location findRandomWithin(Location origin, Conditional condition, boolean includeSelf, double distance) {
        List locations = this.findWithin(origin.getCoordinate(), condition, includeSelf, distance);
        if (!locations.isEmpty()) {
            return (Location)locations.get(this.randomToLimit(locations.size()));
        }
        return null;
    }

    public Location findMinimum(DataPoint point) {
        return this.findMinimum(this.iterator(), point);
    }

    public Location findMaximum(DataPoint point) {
        return this.findMaximum(this.iterator(), point);
    }

    public Location get(Coordinate coordinate) {
        try {
            return (Location)((List)this.collection).get(((Coordinate1DDiscrete)coordinate).getXValue());
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("The underlying space is not a list and cannot be accessed randomly.");
        }
    }

    public void set(Coordinate coordinate, Location agent) {
        try {
            ((List)this.collection).set(((Coordinate1DDiscrete)coordinate).getXValue(), agent);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("The underlying space is not a list and cannot be accessed randomly.");
        }
    }

    public void setExtent(int size) {
        this.setSize(size);
    }

    public int size() {
        return this.getSize();
    }

    public int getSize() {
        return ((Coordinate1DDiscrete)this.extent).getXValue();
    }

    public Coordinate getExtent() {
        return this.extent;
    }

    public void setExtent(Coordinate extent) {
        this.extent = extent;
    }

    public boolean isDeleteSweepNeeded() {
        return this.deleteSweepNeeded;
    }

    public void setSize(int internalSize) {
        ((Coordinate1DDiscrete)this.getExtent()).setXValue(internalSize);
    }

    public void construct() {
        this.collection = new ArrayList(ESTIMATED_MAXIMUM_SIZE);
    }

    public void populate() {
        if (this.extent != null) {
            Location[] newPopulation = new Location[this.getSize()];
            int i = 0;
            while (i < newPopulation.length) {
                newPopulation[i] = (Location)this.getContext().getPrototype().clone();
                ++i;
            }
            this.collection.clear();
            this.collection.addAll(Arrays.asList(newPopulation));
        }
    }

    public void initialize() {
    }

    public int randomInRange(int low, int high) {
        return this.random.nextInt(high - low + 1) + low;
    }

    public double randomInRange(double low, double high) {
        return this.random.nextDouble() * (high - low) + low;
    }

    public int randomToLimit(int limit) {
        return this.random.nextInt(limit);
    }

    public boolean randomIs() {
        return this.random.nextBoolean();
    }

    public SpaceContext getContext() {
        return this.context;
    }

    public void setContext(SpaceContext context) {
        this.context = context;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    protected void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public boolean isPeriodic() {
        return this.geometry.isPeriodic();
    }

    public void setPeriodic(boolean periodic) {
        this.geometry.setPeriodic(periodic);
    }

    public Object clone() {
        try {
            CollectionSpace clone = (CollectionSpace)super.clone();
            clone.collection = new ArrayList();
            clone.extent = new Coordinate1DDiscrete(0);
            if (this.geometry != null) {
                clone.geometry = (Geometry)this.geometry.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException();
        }
    }

    public static int[] createOrder(int length) {
        int[] order = new int[length];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        return order;
    }

    public static int[] randomizeOrder(int[] order, Random random) {
        int j = order.length - 1;
        while (j > 0) {
            int k = (random.nextInt() & Integer.MAX_VALUE) % (j + 1);
            if (k != j) {
                int swap = order[j];
                order[j] = order[k];
                order[k] = swap;
            }
            --j;
        }
        return order;
    }

    public List toList() {
        return new ArrayList(this);
    }

    protected class CSIterator
    implements ResetableIterator,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected List copy;
        protected transient ListIterator copyIterator;

        public CSIterator() {
            this.copy = new ArrayList(CollectionSpace.this.collection);
            this.copyIterator = this.copy.listIterator();
        }

        public void first() {
            this.copyIterator = this.copy.listIterator();
        }

        public boolean hasNext() {
            return this.copyIterator.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove an agent from an immutable context!");
        }

        public Object next() {
            return this.copyIterator.next();
        }
    }

    protected class CSMutableIterator
    extends CSIterator {
        private static final long serialVersionUID = 1L;
        int i;

        protected CSMutableIterator() {
        }

        public final boolean hasNext() {
            while (this.copyIterator.hasNext()) {
                if (!((Location)this.copy.get(this.copyIterator.nextIndex())).isDelete()) {
                    return true;
                }
                this.copyIterator.next();
            }
            return false;
        }

        public final void remove() {
            Object removeObject = this.copy.get(this.i);
            CollectionSpace.this.collection.remove(removeObject);
            this.copy.remove(removeObject);
        }

        public final Object next() {
            ++this.i;
            Object candidate = this.copyIterator.next();
            while (((Location)candidate).isDelete()) {
                candidate = this.copyIterator.next();
            }
            return candidate;
        }
    }

    public class ClosestDataPoint
    extends DataPointConcrete {
        private static final long serialVersionUID = 1L;
        Coordinate origin;

        public ClosestDataPoint(Coordinate origin) {
            super("Closest Point");
            this.origin = origin;
        }

        public double getValue(Object o) {
            return CollectionSpace.this.calculateDistance(this.origin, ((Location)o).getCoordinate());
        }
    }

    public static class ConditionalIterator
    implements Iterator {
        Iterator iter;
        Conditional condition;
        Object next;

        public ConditionalIterator(Iterator iter, Conditional condition) {
            this.iter = iter;
            this.condition = condition;
            this.loadNext();
        }

        private void loadNext() {
            this.next = null;
            while (this.iter.hasNext() && this.next == null) {
                Object o = this.iter.next();
                if (!this.condition.meetsCondition(o)) continue;
                this.next = o;
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next != null) {
                Object currentNext = this.next;
                this.loadNext();
                return currentNext;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove from a conditional iterator.");
        }
    }

    protected class ListMutableRandomIterator
    extends CSMutableIterator
    implements RandomIterator {
        private static final long serialVersionUID = 1L;

        public ListMutableRandomIterator() {
            this.randomize();
        }

        public void randomize() {
            Collections.shuffle(this.copy, CollectionSpace.this.getRandom());
        }
    }

    protected class ListRandomIterator
    extends CSIterator
    implements RandomIterator {
        private static final long serialVersionUID = 1L;

        public ListRandomIterator() {
            this.randomize();
        }

        public void randomize() {
            Collections.shuffle(this.copy, CollectionSpace.this.getRandom());
        }
    }

    protected class MutableSubIterator
    extends CSMutableIterator {
        private static final long serialVersionUID = 1L;

        public MutableSubIterator(int start, int limit) {
            CollectionSpace.this.deleteSweep();
            this.copy = new ArrayList(((AbstractList)CollectionSpace.this.collection).subList(start, limit));
            this.copyIterator = this.copy.listIterator();
        }
    }

    protected class SubIterator
    extends CSIterator {
        private static final long serialVersionUID = 1L;

        public SubIterator(int start, int limit) {
            this.copy = new ArrayList(((AbstractList)CollectionSpace.this.collection).subList(start, limit));
            this.copyIterator = this.copy.listIterator();
        }
    }
}

