/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.export;

import org.eclipse.draw3d.Export3DOperation;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DRegistry;
import org.eclipse.draw3d.ui.Draw3DUIPlugin;
import org.eclipse.draw3d.ui.export.Export3DFigureProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class Export3DAction
extends Action {
    public static final String ID = Export3DAction.class.getName();
    private Export3DFigureProvider m_provider;
    private final String m_rendererId;

    public static final String actionID(String rendererID) {
        return String.valueOf(ID) + "_" + rendererID;
    }

    public Export3DAction(String i_rendererId, Export3DFigureProvider i_provider) {
        if (i_rendererId == null) {
            throw new NullPointerException("i_rendererId must not be null");
        }
        if (i_provider == null) {
            throw new NullPointerException("i_provider must not be null");
        }
        this.m_rendererId = i_rendererId;
        this.m_provider = i_provider;
        this.setId(Export3DAction.actionID(this.m_rendererId));
        this.init();
    }

    public String getRendererId() {
        return this.m_rendererId;
    }

    protected void init() {
        if (this.m_rendererId != null) {
            Graphics3DDescriptor descr = Graphics3DRegistry.getRenderer((String)this.m_rendererId);
            if (descr != null) {
                this.setText("Export " + descr.getName());
                this.setToolTipText(descr.getDescription());
                this.setId(this.getId());
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void run() {
        Shell shell = Draw3DUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Export");
        String strExportFile = fd.open();
        if (strExportFile != null) {
            IFigure3D figure = this.m_provider.getFigure();
            Export3DOperation operation = new Export3DOperation(strExportFile, this.m_rendererId, figure);
            operation.run();
        }
    }
}

