/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.font;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Vector2fImpl;
import org.eclipse.draw3d.util.Draw3DCache;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.GLUtessellator;
import org.lwjgl.util.glu.GLUtessellatorCallback;
import org.lwjgl.util.glu.GLUtessellatorCallbackAdapter;

public class LwjglVectorFont {
    private static final Logger log = Logger.getLogger(LwjglVectorFont.class.getName());
    private boolean m_antialias;
    private Font m_awtFont;
    private int m_bufferId;
    private char m_endChar;
    private char m_startChar;
    private int m_listBaseId;
    private int m_offsetBaseId_StartChar;

    private static int getAwtStyle(boolean i_bold, boolean i_italic) {
        int awtStyle = 0;
        if (i_bold) {
            awtStyle |= 1;
        }
        if (i_italic) {
            awtStyle |= 2;
        }
        return awtStyle;
    }

    public LwjglVectorFont(org.eclipse.swt.graphics.Font i_swtFont, char i_startChar, char i_endChar, boolean i_antialias) {
        this(i_swtFont.getFontData()[0].getName(), i_swtFont.getFontData()[0].getHeight(), (i_swtFont.getFontData()[0].getStyle() & 1) != 0, (i_swtFont.getFontData()[0].getStyle() & 2) != 0, i_startChar, i_endChar, i_antialias);
    }

    public LwjglVectorFont(String i_name, int i_height, boolean i_bold, boolean i_italic, char i_startChar, char i_endChar, boolean i_antialias) {
        this(i_name, i_height, LwjglVectorFont.getAwtStyle(i_bold, i_italic), i_startChar, i_endChar, i_antialias);
    }

    public LwjglVectorFont(String i_name, int i_height, int i_awtStyle, char i_startChar, char i_endChar, boolean i_antialias) {
        if (i_name == null) {
            throw new NullPointerException("i_name must not be null");
        }
        this.m_awtFont = new Font(i_name, i_awtStyle, i_height);
        this.m_startChar = i_startChar;
        this.m_endChar = i_endChar;
        this.m_antialias = i_antialias;
    }

    public void dispose() {
        IntBuffer idBuffer = Draw3DCache.getIntBuffer((int)1);
        try {
            idBuffer.put(this.m_bufferId);
            idBuffer.rewind();
            GL15.glDeleteBuffers((IntBuffer)idBuffer);
            this.m_bufferId = 0;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
    }

    private int generateBufferId() {
        int n;
        IntBuffer idBuffer = Draw3DCache.getIntBuffer((int)1);
        try {
            int id;
            idBuffer.rewind();
            GL15.glGenBuffers((IntBuffer)idBuffer);
            n = id = idBuffer.get(0);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
        return n;
    }

    public Font getAwtFont() {
        return this.m_awtFont;
    }

    public void initialize() {
        GLUtessellator tesselator = GLU.gluNewTess();
        try {
            FontCallback callback = new FontCallback();
            tesselator.gluTessCallback(100104, null);
            tesselator.gluTessCallback(100110, null);
            tesselator.gluTessCallback(100100, (GLUtessellatorCallback)callback);
            tesselator.gluTessCallback(100106, null);
            tesselator.gluTessCallback(100101, (GLUtessellatorCallback)callback);
            tesselator.gluTessCallback(100107, null);
            tesselator.gluTessCallback(100105, (GLUtessellatorCallback)callback);
            tesselator.gluTessCallback(100111, null);
            tesselator.gluTessCallback(100102, (GLUtessellatorCallback)callback);
            tesselator.gluTessCallback(100108, null);
            tesselator.gluTessCallback(100103, (GLUtessellatorCallback)callback);
            tesselator.gluTessCallback(100109, null);
            tesselator.gluTessProperty(100142, 0.0);
            tesselator.gluTessProperty(100141, 0.0);
            tesselator.gluTessNormal(0.0, 0.0, -1.0);
            int charCount = this.m_endChar - this.m_startChar + 1;
            char[] chars = new char[charCount];
            int i = 0;
            while (i < charCount) {
                chars[i] = (char)(this.m_startChar + i);
                ++i;
            }
            float[][][] vertices = new float[charCount][][];
            int[][] indices = new int[charCount][];
            int[][] lengths = new int[charCount][];
            int[][] types = new int[charCount][];
            float[] advances = new float[charCount];
            FontRenderContext ctx = new FontRenderContext(null, this.m_antialias, true);
            GlyphVector glyphs = this.m_awtFont.createGlyphVector(ctx, chars);
            int totalVertexCount = 0;
            double[] coords = new double[]{0.0, 0.0, 0.0};
            AffineTransform af = new AffineTransform();
            af.translate(0.0, this.m_awtFont.getSize());
            int i2 = 0;
            while (i2 < charCount) {
                Shape outline = glyphs.getGlyphOutline(i2);
                PathIterator path = outline.getPathIterator(af, 0.01);
                if (!path.isDone()) {
                    if (path.getWindingRule() == 0) {
                        tesselator.gluTessProperty(100140, 100130.0);
                    } else if (path.getWindingRule() == 1) {
                        tesselator.gluTessProperty(100140, 100131.0);
                    }
                    tesselator.gluTessBeginPolygon((Object)Character.valueOf(chars[i2]));
                    while (!path.isDone()) {
                        int segmentType = path.currentSegment(coords);
                        switch (segmentType) {
                            case 0: {
                                tesselator.gluTessBeginContour();
                                tesselator.gluTessVertex(coords, 0, (Object)new Vector2fImpl((float)coords[0], (float)coords[1]));
                                break;
                            }
                            case 4: {
                                tesselator.gluTessEndContour();
                                break;
                            }
                            case 1: {
                                tesselator.gluTessVertex(coords, 0, (Object)new Vector2fImpl((float)coords[0], (float)coords[1]));
                            }
                        }
                        path.next();
                    }
                    tesselator.gluTessEndPolygon();
                    int count = callback.getCount();
                    vertices[i2] = new float[count][];
                    types[i2] = new int[count];
                    lengths[i2] = new int[count];
                    indices[i2] = new int[count];
                    int j = 0;
                    while (j < count) {
                        vertices[i2][j] = callback.getVertices(j);
                        types[i2][j] = callback.getType(j);
                        indices[i2][j] = totalVertexCount;
                        lengths[i2][j] = vertices[i2][j].length / 2;
                        totalVertexCount += lengths[i2][j];
                        ++j;
                    }
                    callback.reset();
                }
                GlyphMetrics metrics = glyphs.getGlyphMetrics(i2);
                advances[i2] = metrics.getAdvanceX();
                af.translate(-advances[i2], 0.0);
                ++i2;
            }
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(2 * totalVertexCount));
            int i3 = 0;
            while (i3 < vertices.length) {
                if (vertices[i3] != null) {
                    int j = 0;
                    while (j < vertices[i3].length) {
                        buffer.put(vertices[i3][j]);
                        ++j;
                    }
                }
                ++i3;
            }
            this.m_bufferId = this.generateBufferId();
            this.uploadBuffer(this.m_bufferId, buffer);
            GL15.glBindBuffer((int)34962, (int)this.m_bufferId);
            GL11.glEnableClientState((int)32884);
            try {
                GL11.glVertexPointer((int)2, (int)5126, (int)0, (long)0L);
                this.m_listBaseId = GL11.glGenLists((int)charCount);
                this.m_offsetBaseId_StartChar = this.m_listBaseId - this.m_startChar;
                i3 = 0;
                while (i3 < charCount) {
                    int listId = this.m_listBaseId + i3;
                    GL11.glNewList((int)listId, (int)4864);
                    float advance = advances[i3];
                    int[] indicesPerChar = indices[i3];
                    if (indicesPerChar != null) {
                        int[] typesPerChar = types[i3];
                        int[] lengthsPerChar = lengths[i3];
                        int j = 0;
                        while (j < indicesPerChar.length) {
                            int length = lengthsPerChar[j];
                            if (length > 0) {
                                int index = indicesPerChar[j];
                                int type = typesPerChar[j];
                                GL11.glDrawArrays((int)type, (int)index, (int)length);
                            }
                            ++j;
                        }
                    }
                    GL11.glTranslatef((float)advance, (float)0.0f, (float)0.0f);
                    GL11.glEndList();
                    ++i3;
                }
            }
            finally {
                GL11.glDisableClientState((int)32884);
            }
        }
        finally {
            tesselator.gluDeleteTess();
        }
    }

    public void render(String i_string) {
        if (i_string == null) {
            throw new NullPointerException("i_string must not be null");
        }
        GL15.glBindBuffer((int)34962, (int)this.m_bufferId);
        GL11.glEnableClientState((int)32884);
        try {
            GL11.glVertexPointer((int)2, (int)5126, (int)0, (long)0L);
            IntBuffer listIdBuffer = Draw3DCache.getIntBuffer((int)i_string.length());
            try {
                listIdBuffer.rewind();
                int l = i_string.length();
                int i = 0;
                while (i < l) {
                    char c = i_string.charAt(i);
                    if (c >= this.m_startChar && c <= this.m_endChar) {
                        listIdBuffer.put(this.m_offsetBaseId_StartChar + c);
                    } else {
                        listIdBuffer.put(this.m_offsetBaseId_StartChar + 95);
                    }
                    ++i;
                }
                listIdBuffer.limit(listIdBuffer.position());
                listIdBuffer.rewind();
                GL11.glPolygonMode((int)1032, (int)6914);
                GL11.glCallLists((IntBuffer)listIdBuffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{listIdBuffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{listIdBuffer});
        }
        finally {
            GL11.glDisableClientState((int)32884);
        }
    }

    private void uploadBuffer(int i_bufferId, FloatBuffer i_buffer) {
        i_buffer.rewind();
        GL15.glBindBuffer((int)34962, (int)i_bufferId);
        GL15.glBufferData((int)34962, (FloatBuffer)i_buffer, (int)35041);
    }

    private static class FontCallback
    extends GLUtessellatorCallbackAdapter {
        private int m_currentType = 0;
        private int m_currentVertexCount = 0;
        private float[] m_currentVertices = new float[32];
        private int m_primCount = 0;
        private int[] m_types = new int[4];
        private float[][] m_vertices = new float[4][];

        public void begin(int i_type) {
            this.m_currentType = i_type;
        }

        public void combine(double[] i_coords, Object[] i_data, float[] i_weight, Object[] i_outData) {
            i_outData[0] = new Vector2fImpl((float)i_coords[0], (float)i_coords[1]);
        }

        public void end() {
            Object temp;
            if (this.m_primCount == this.m_vertices.length) {
                temp = this.m_vertices;
                this.m_vertices = new float[2 * ((float[][])temp).length][];
                System.arraycopy(temp, 0, this.m_vertices, 0, ((float[][])temp).length);
            }
            this.m_vertices[this.m_primCount] = new float[2 * this.m_currentVertexCount];
            System.arraycopy(this.m_currentVertices, 0, this.m_vertices[this.m_primCount], 0, 2 * this.m_currentVertexCount);
            if (this.m_primCount == this.m_types.length) {
                temp = this.m_types;
                this.m_types = new int[2 * this.m_types.length];
                System.arraycopy(temp, 0, this.m_types, 0, ((float[][])temp).length);
            }
            this.m_types[this.m_primCount] = this.m_currentType;
            ++this.m_primCount;
            this.m_currentVertexCount = 0;
            this.m_currentType = 0;
        }

        public void error(int i_errnum) {
            throw new RuntimeException("caught error during polygon tesselation: " + i_errnum);
        }

        public int getCount() {
            return this.m_primCount;
        }

        public int getType(int i_index) {
            if (i_index < 0 || i_index >= this.m_primCount) {
                throw new IndexOutOfBoundsException();
            }
            return this.m_types[i_index];
        }

        public float[] getVertices(int i_index) {
            if (i_index < 0 || i_index >= this.m_primCount) {
                throw new IndexOutOfBoundsException();
            }
            return this.m_vertices[i_index];
        }

        public void reset() {
            this.m_primCount = 0;
            this.m_currentVertexCount = 0;
            this.m_currentType = 0;
        }

        public void vertex(Object i_vertexData) {
            if (this.m_currentVertexCount == this.m_currentVertices.length / 2) {
                float[] temp = this.m_currentVertices;
                this.m_currentVertices = new float[2 * temp.length];
                System.arraycopy(temp, 0, this.m_currentVertices, 0, temp.length);
            }
            IVector2f vertex = (IVector2f)i_vertexData;
            vertex.toArray(this.m_currentVertices, 2 * this.m_currentVertexCount++);
        }
    }
}

