/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.ConnectionAnchor3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class XYZAnchor
extends XYAnchor
implements ConnectionAnchor3D {
    Vector3fImpl m_location3D = new Vector3fImpl();

    public XYZAnchor(Vector3fImpl i_location) {
        super(new Point((int)i_location.getX(), (int)i_location.getY()));
        this.m_location3D.set((IVector3f)i_location);
    }

    public IVector3f getLocation3D(IVector3f i_reference, Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set((IVector3f)this.m_location3D);
        return result;
    }

    public IVector3f getReferencePoint3D(Vector3f io_result) {
        return this.getLocation3D(null, io_result);
    }

    public void setLocation(Point i_p) {
        this.m_location3D.set((float)i_p.x, (float)i_p.y, 10.0f);
        super.setLocation(i_p);
    }

    public void setLocation3D(IVector3f i_location) {
        this.m_location3D.set(i_location);
        this.fireAnchorMoved();
    }

    public static class Immutable
    extends XYZAnchor {
        public Immutable(Vector3fImpl i_location) {
            super(i_location);
        }

        public void setLocation(Point i_p) {
            throw new UnsupportedOperationException("Anchor is immutable");
        }

        public void setLocation3D(IVector3f i_location) {
            throw new UnsupportedOperationException("Anchor is immutable");
        }

        public void addAnchorListener(AnchorListener i_listener) {
        }
    }
}

