/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.amf.ide;

import org.ascape.runtime.Runner;
import org.eclipse.amp.amf.parameters.AParFactory;
import org.eclipse.amp.amf.parameters.AParInterpreter;
import org.eclipse.amp.escape.command.ExecuteHandler;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.metaabm.SContext;

public class ExecuteParameterHandler
extends ExecuteHandler {
    private AParInterpreter interpreter;
    protected IResource modelResource;
    private SContext model;

    public ExecuteParameterHandler(boolean headless) {
        super(headless);
    }

    public ExecuteParameterHandler() {
        super(false);
    }

    protected void executeOpen(EclipseEscapeRunner eclipseRunner, Object executed, IProgressMonitor monitor) {
        if (executed instanceof IResource) {
            this.modelResource = (IResource)executed;
            IProject project = this.modelResource.getProject();
            if (this.modelResource.getFileExtension().equals("apar")) {
                this.setInterpreter((AParInterpreter)AParFactory.create(null).getInterpreter(this.modelResource));
                eclipseRunner.setAutoRestart(false);
                this.model = this.getInterpreter().getRootContext();
                eclipseRunner.open((IResource)project, this.model.getImplementation().getQualifiedName(), this.getInterpreter().getRunName(), this.getInterpreter().getArgs());
            }
        }
    }

    protected EclipseEscapeRunner createRunner() {
        Runner.setDisplayGraphics((!this.isHeadless() ? 1 : 0) != 0);
        EclipseEscapeRunner runner = new EclipseEscapeRunner(){
            private static final long serialVersionUID = 1L;

            public void openImplementation(String[] args, boolean block) {
                ExecuteParameterHandler.this.getInterpreter().assignValues(new Object[]{this.getRootScape(), this}, null);
                super.openImplementation(args, block);
            }
        };
        return runner;
    }

    protected boolean handleSelect(Object sel) {
        return sel instanceof IResource && ((IResource)sel).getFileExtension() != null && ((IResource)sel).getFileExtension().equals("apar");
    }

    public void setInterpreter(AParInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public AParInterpreter getInterpreter() {
        return this.interpreter;
    }

    public SContext getModel() {
        return this.model;
    }
}

