/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.util.Calendar;
import java.util.Vector;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataElementComposite;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DateTimeDataElementComposite
extends Composite
implements IDataElementComposite,
Listener {
    private Button btnDate;
    private Button btnTime;
    private DateTime pickerDate;
    private DateTime pickerTime;
    private Vector<Listener> vListeners = null;
    private final boolean isNullAllowed;

    public DateTimeDataElementComposite(Composite parent, int style, DateTimeDataElement data, boolean isNullAllowed) {
        super(parent, 0);
        this.isNullAllowed = isNullAllowed;
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        this.btnDate = new Button((Composite)this, 32);
        this.btnDate.addListener(13, (Listener)this);
        this.pickerDate = new DateTime((Composite)this, 0x20 | style);
        this.pickerDate.setLayoutData((Object)new GridData(768));
        this.pickerDate.addListener(13, (Listener)this);
        this.btnTime = new Button((Composite)this, 32);
        this.btnTime.addListener(13, (Listener)this);
        this.pickerTime = new DateTime((Composite)this, 0x80 | style);
        this.pickerTime.setLayoutData((Object)new GridData(768));
        this.pickerTime.addListener(13, (Listener)this);
        this.vListeners = new Vector();
        this.setDataElement((DataElement)data);
    }

    public void setEnabled(boolean enabled) {
        this.btnDate.setEnabled(enabled);
        this.btnTime.setEnabled(enabled);
        this.pickerDate.setEnabled(enabled && this.btnDate.getSelection());
        this.pickerTime.setEnabled(enabled && this.btnTime.getSelection());
    }

    public DataElement getDataElement() {
        if (this.isNullAllowed && !this.btnDate.getSelection() && !this.btnTime.getSelection()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = 1970;
        int month = 0;
        int day = 1;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (this.btnDate.getSelection()) {
            year = this.pickerDate.getYear();
            month = this.pickerDate.getMonth();
            day = this.pickerDate.getDay();
        }
        if (this.btnTime.getSelection()) {
            hours = this.pickerTime.getHours();
            minutes = this.pickerTime.getMinutes();
            seconds = this.pickerTime.getSeconds();
        }
        calendar.set(year, month, day, hours, minutes, seconds);
        calendar.set(14, 0);
        return DateTimeDataElementImpl.create((Calendar)calendar);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btnDate) {
            this.pickerDate.setEnabled(this.btnDate.getSelection());
        } else if (event.widget == this.btnTime) {
            this.pickerTime.setEnabled(this.btnTime.getSelection());
        }
        event.widget = this;
        int i = 0;
        while (i < this.vListeners.size()) {
            Event e = new Event();
            e.data = this.getDataElement();
            e.widget = this;
            e.type = 0;
            this.vListeners.get(i).handleEvent(e);
            ++i;
        }
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void setDataElement(DataElement data) {
        if (data != null && !(data instanceof DateTimeDataElement)) {
            return;
        }
        CDateTime calendar = null;
        calendar = data != null ? ((DateTimeDataElement)data).getValueAsCDateTime() : new CDateTime(1970, 1, 1, 0, 0, 0);
        if (calendar.getYear() == 1970 && calendar.getMonth() == 0 && calendar.getDay() == 1) {
            this.btnDate.setSelection(false);
            this.pickerDate.setEnabled(false);
        } else {
            this.btnDate.setSelection(true);
            this.pickerDate.setEnabled(true);
        }
        if (calendar.getHour() == 0 && calendar.getMinute() == 0 && calendar.getSecond() == 0) {
            this.btnTime.setSelection(false);
            this.pickerTime.setEnabled(false);
        } else {
            this.btnTime.setSelection(true);
            this.pickerTime.setEnabled(true);
        }
        this.pickerDate.setYear(calendar.getYear());
        this.pickerDate.setMonth(calendar.getMonth());
        this.pickerDate.setDay(calendar.getDay());
        this.pickerTime.setHours(calendar.getHour());
        this.pickerTime.setMinutes(calendar.getMinute());
        this.pickerTime.setSeconds(calendar.getSecond());
    }
}

