/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;

public class PieSeriesAttributeComposite
extends Composite
implements Listener,
SelectionListener {
    private Group grpLeaderLine = null;
    private FillChooserComposite fccSliceOutline = null;
    private Combo cmbLeaderLine = null;
    private Spinner iscLeaderLength = null;
    private LineAttributesComposite liacLeaderLine = null;
    private PieSeries series = null;
    private static final int MAX_LEADER_LENGTH = 200;
    private ChartWizardContext context;
    private TextEditorComposite txtExplode;
    private Button btnBuilder;
    private Label lblExpSliWhen;
    private Label lblExpDistance;
    private Label lblRatio;
    private Label lblRotation;
    private Spinner iscExplosion;
    private Slider sRatio;
    private Slider sRotation;
    private Button btnDirection;
    private static final String TOOLTIP_EXPLODE_SLICE_WHEN = Messages.getString("PieBottomAreaComponent.Label.TheExplosionCondition");
    private static final String TOOLTIP_EXPLOSION_DISTANCE = Messages.getString("PieBottomAreaComponent.Label.TheAmplitudeOfTheExplosion");
    private static final String TOOLTIP_RATIO = Messages.getString("PieBottomAreaComponent.Label.TheRatioOfTheChart");
    private static final String TOOLTIP_ROTATION = Messages.getString("PiesBottomAreaComponent.Label.TheRotationOfTheChart");
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public PieSeriesAttributeComposite(Composite parent, int style, Series series, ChartWizardContext context) {
        super(parent, style);
        this.context = context;
        if (!(series instanceof PieSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "PieSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (PieSeries)series;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatPieChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 2;
        glContent.marginWidth = 4;
        this.setLayout((Layout)glContent);
        this.grpLeaderLine = new Group((Composite)this, 0);
        GridData gdGRPLeaderLine = new GridData(1808);
        this.grpLeaderLine.setLayoutData((Object)gdGRPLeaderLine);
        GridLayout glLeaderLine = new GridLayout();
        glLeaderLine.numColumns = 2;
        glLeaderLine.marginHeight = 0;
        glLeaderLine.marginWidth = 2;
        glLeaderLine.verticalSpacing = 0;
        this.grpLeaderLine.setLayout((Layout)glLeaderLine);
        this.grpLeaderLine.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLine"));
        this.liacLeaderLine = new LineAttributesComposite((Composite)this.grpLeaderLine, 0, this.context, this.series.getLeaderLineAttributes(), true, true, true, true, true);
        GridData gdLIACLeaderLine = new GridData(768);
        gdLIACLeaderLine.horizontalSpan = 2;
        this.liacLeaderLine.setLayoutData(gdLIACLeaderLine);
        this.liacLeaderLine.addListener(this);
        Composite cmpStyle = new Composite((Composite)this.grpLeaderLine, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        cmpStyle.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        cmpStyle.setLayoutData((Object)gd);
        Label lblLeaderStyle = new Label(cmpStyle, 0);
        GridData gdLBLLeaderStyle = new GridData();
        lblLeaderStyle.setLayoutData((Object)gdLBLLeaderStyle);
        lblLeaderStyle.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLineStyle"));
        this.cmbLeaderLine = new Combo(cmpStyle, 12);
        GridData gdCMBLeaderLine = new GridData(768);
        this.cmbLeaderLine.setLayoutData((Object)gdCMBLeaderLine);
        this.cmbLeaderLine.addSelectionListener((SelectionListener)this);
        Label lblLeaderSize = new Label(cmpStyle, 0);
        GridData gdLBLLeaderSize = new GridData();
        lblLeaderSize.setLayoutData((Object)gdLBLLeaderSize);
        lblLeaderSize.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLineLength"));
        this.iscLeaderLength = new Spinner(cmpStyle, 2048);
        GridData gdISCLeaderLength = new GridData(768);
        this.iscLeaderLength.setLayoutData((Object)gdISCLeaderLength);
        this.iscLeaderLength.setMinimum(0);
        this.iscLeaderLength.setMaximum(200);
        this.iscLeaderLength.setSelection((int)this.series.getLeaderLineLength());
        this.iscLeaderLength.addSelectionListener((SelectionListener)this);
        Composite cmpRight = new Composite((Composite)this, 0);
        cmpRight.setLayout((Layout)new GridLayout(3, false));
        cmpRight.setLayoutData((Object)new GridData(1808));
        this.createSeriesDetail(cmpRight);
        this.populateLists();
    }

    private void createSeriesDetail(Composite cmpRight) {
        this.lblRatio = new Label(cmpRight, 0);
        this.lblRatio.setText(Messages.getString("PieBottomAreaComponent.Label.Ratio"));
        this.lblRatio.setToolTipText(TOOLTIP_RATIO);
        this.sRatio = new Slider(cmpRight, 256);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.sRatio.setLayoutData((Object)gridData);
        this.sRatio.setValues((int)(this.series.getRatio() * 10.0), 1, 101, 1, 1, 10);
        this.sRatio.setToolTipText(String.valueOf(this.series.getRatio()));
        this.sRatio.setEnabled(true);
        this.sRatio.addSelectionListener((SelectionListener)this);
        this.sRatio.addListener(16, (Listener)this);
        this.sRatio.addListener(1, (Listener)this);
        this.sRatio.addListener(31, (Listener)this);
        this.lblRotation = new Label(cmpRight, 0);
        this.lblRotation.setText(Messages.getString("PieBottomAreaComponent.Label.Rotation"));
        this.lblRotation.setToolTipText(TOOLTIP_ROTATION);
        this.sRotation = new Slider(cmpRight, 256);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.sRotation.setLayoutData((Object)gridData);
        this.sRotation.setValues((int)this.series.getRotation(), 0, 360, 1, 1, 10);
        this.sRotation.setToolTipText(String.valueOf(this.series.getRotation()));
        this.sRotation.setEnabled(true);
        this.sRotation.addSelectionListener((SelectionListener)this);
        this.sRotation.addListener(16, (Listener)this);
        this.sRotation.addListener(1, (Listener)this);
        this.sRotation.addListener(31, (Listener)this);
        this.btnDirection = new Button(cmpRight, 32);
        this.btnDirection.setText(Messages.getString("PieSeriesAttributeComposite.Button.Direction"));
        this.btnDirection.setToolTipText(Messages.getString("PieSeriesAttributeComposite.Button.Direction.ToolTipText"));
        this.btnDirection.addListener(13, (Listener)this);
        this.btnDirection.setSelection(this.series.isClockwise());
        Group grpSlice = new Group(cmpRight, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        grpSlice.setLayoutData((Object)gd);
        grpSlice.setLayout((Layout)gridLayout);
        grpSlice.setText(Messages.getString("PieSeriesAttributeComposite.Grp.Slice"));
        this.lblExpSliWhen = new Label((Composite)grpSlice, 0);
        this.lblExpSliWhen.setText(Messages.getString("PieBottomAreaComponent.Label.ExplodeSliceWhen"));
        this.lblExpSliWhen.setToolTipText(TOOLTIP_EXPLODE_SLICE_WHEN);
        this.txtExplode = new TextEditorComposite((Composite)grpSlice, 2052);
        GridData gd2 = new GridData(768);
        this.txtExplode.setLayoutData(gd2);
        if (this.series.getExplosionExpression() != null) {
            this.txtExplode.setText(this.series.getExplosionExpression());
        }
        this.txtExplode.setToolTipText(Messages.getString("PieBaseSeriesComponent.Tooltip.EnterBooleanExpression"));
        this.txtExplode.addListener(this);
        this.btnBuilder = new Button((Composite)grpSlice, 8);
        GridData gdBTNBuilder = new GridData();
        gdBTNBuilder.heightHint = 20;
        gdBTNBuilder.widthHint = 20;
        this.btnBuilder.setLayoutData((Object)gdBTNBuilder);
        this.btnBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
        this.btnBuilder.addSelectionListener((SelectionListener)this);
        this.btnBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
        this.btnBuilder.getImage().setBackground(this.btnBuilder.getBackground());
        if (this.context.getUIServiceProvider() == null) {
            this.btnBuilder.setEnabled(false);
        }
        this.lblExpDistance = new Label((Composite)grpSlice, 0);
        this.lblExpDistance.setText(Messages.getString("PieBottomAreaComponent.Label.ByDistance"));
        this.lblExpDistance.setToolTipText(TOOLTIP_EXPLOSION_DISTANCE);
        this.iscExplosion = new Spinner((Composite)grpSlice, 2048);
        GridData gdISCExplosion = new GridData(768);
        gdISCExplosion.horizontalSpan = 2;
        this.iscExplosion.setLayoutData((Object)gdISCExplosion);
        this.iscExplosion.setMinimum(0);
        this.iscExplosion.setMaximum(100);
        this.iscExplosion.setSelection(this.series.getExplosion());
        this.iscExplosion.addSelectionListener((SelectionListener)this);
        Label lblSliceOutline = new Label((Composite)grpSlice, 0);
        GridData gdLBLSliceOutline = new GridData();
        lblSliceOutline.setLayoutData((Object)gdLBLSliceOutline);
        lblSliceOutline.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.SliceOutline"));
        this.fccSliceOutline = new FillChooserComposite((Composite)grpSlice, 0, this.context, (Fill)this.series.getSliceOutline(), false, false, false);
        GridData gdFCCSliceOutline = new GridData(768);
        gdFCCSliceOutline.horizontalSpan = 2;
        this.fccSliceOutline.setLayoutData(gdFCCSliceOutline);
        this.fccSliceOutline.addListener(this);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.leaderLineStyleSet;
        this.cmbLeaderLine.setItems(ns.getDisplayNames());
        this.cmbLeaderLine.select(ns.getSafeNameIndex(this.series.getLeaderLineStyle().getName()));
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccSliceOutline)) {
            this.series.setSliceOutline((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.liacLeaderLine)) {
            switch (event.type) {
                case 4: {
                    this.series.getLeaderLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                    break;
                }
                case 1: {
                    this.series.getLeaderLineAttributes().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.series.getLeaderLineAttributes().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.series.getLeaderLineAttributes().setColor((ColorDefinition)event.data);
                }
            }
        } else if (event.widget.equals((Object)this.txtExplode)) {
            this.series.setExplosionExpression(this.txtExplode.getText());
        } else if (event.widget == this.btnDirection) {
            this.series.setClockwise(this.btnDirection.getSelection());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.iscExplosion)) {
            this.series.setExplosion(this.iscExplosion.getSelection());
        } else if (e.getSource().equals(this.iscLeaderLength)) {
            this.series.setLeaderLineLength((double)this.iscLeaderLength.getSelection());
        } else if (e.getSource().equals(this.cmbLeaderLine)) {
            this.series.setLeaderLineStyle(LeaderLineStyle.getByName((String)LiteralHelper.leaderLineStyleSet.getNameByDisplayName(this.cmbLeaderLine.getText())));
        } else if (e.widget.equals(this.btnBuilder)) {
            try {
                String sExpr = this.context.getUIServiceProvider().invoke(2, this.txtExplode.getText(), this.context.getExtendedItem(), Messages.getString("PieBaseSeriesComponent.Text.SpecifyExplodeSlice"));
                this.txtExplode.setText(sExpr);
                this.txtExplode.setToolTipText(sExpr);
                this.series.setExplosionExpression(sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        }
        if (e.widget.equals(this.sRatio)) {
            this.series.setRatio((double)this.sRatio.getSelection() / 10.0);
            this.sRatio.setToolTipText(String.valueOf(this.series.getRatio()));
        }
        if (e.widget.equals(this.sRotation)) {
            this.series.setRotation((double)this.sRotation.getSelection());
            this.sRotation.setToolTipText(String.valueOf(this.series.getRotation()));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

