/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.processing;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.model.VarValueTO;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugStackFrame;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugTarget;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugThread;
import org.eclipse.emf.mwe.internal.ui.debug.processing.handlers.BreakpointPluginHandler;
import org.eclipse.emf.mwe.internal.ui.debug.processing.handlers.CommandPluginHandler;
import org.eclipse.emf.mwe.internal.ui.debug.processing.handlers.VariablesPluginHandler;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.emf.mwe.ui.debug.model.MWEBreakpoint;
import org.eclipse.emf.mwe.ui.debug.processing.PluginExtensionManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugModelManager
implements IDebugEventSetListener {
    private final DebugTarget target;
    private PluginExtensionManager extensionManager;
    private CommandPluginHandler cmdHandler;
    private VariablesPluginHandler varHandler;
    private BreakpointPluginHandler bpHandler;

    public static DebugModelManager newDebugModelManager(DebugTarget target, Connection connection) throws DebugException {
        DebugModelManager dmm = new DebugModelManager(target);
        dmm.extensionManager = PluginExtensionManager.getDefault();
        dmm.extensionManager.init(dmm, connection);
        return dmm;
    }

    private DebugModelManager(DebugTarget target) {
        this.target = target;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void setCmdHandler(CommandPluginHandler cmdHandler) {
        this.cmdHandler = cmdHandler;
    }

    public void setVariablesHandler(VariablesPluginHandler varHandler) {
        this.varHandler = varHandler;
    }

    public void setBreakpointHandler(BreakpointPluginHandler bpHandler) {
        this.bpHandler = bpHandler;
    }

    public boolean hasRequiredHandlers() {
        return this.cmdHandler != null && this.varHandler != null && this.bpHandler != null;
    }

    public DebugTarget getTarget() {
        return this.target;
    }

    public DebugThread getThread() {
        return this.target.getThread();
    }

    public void debuggerStarted() throws DebugException {
        if (this.shallStopInMain()) {
            this.cmdHandler.sendSuspendCommand();
        }
        this.target.setSuspended(false);
        this.target.installDeferredBreakpoints();
        this.fireCreationEvent();
    }

    public void adaptStackFrames(int cleanStackLevel, List<SyntaxElement> frames) {
        this.getThread().clearStack(cleanStackLevel);
        this.getThread().pushStackFrames(frames);
        this.target.setVariablesDirty();
        this.getThread().setVariablesDirty();
    }

    public void debuggerSuspended() {
        this.target.setSuspended(true);
        int detail = this.checkBreakPoint() ? 16 : 32;
        this.fireSuspendEvent(detail);
    }

    public void debuggerResumed() {
        this.target.setSuspended(false);
        this.fireResumeEvent(32);
    }

    public void debuggerTerminated() {
        this.target.setSuspended(true);
        this.getThread().setStepping(false);
        this.fireSuspendEvent(32);
        try {
            Thread.sleep(700L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this.target);
                this.getThread().clearStack(0);
                this.target.removeThread();
                this.fireTerminateEvent();
            }
            ++n2;
        }
    }

    private boolean shallStopInMain() {
        try {
            return this.target.getLaunch().getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, true);
        }
        catch (CoreException e) {
            return true;
        }
    }

    private boolean checkBreakPoint() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.emf.mwe.debug.model");
        DebugStackFrame frame = this.getThread().getStackFramePeek();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (((MWEBreakpoint)bp).equals(frame.getCharStart(), frame.getResource())) {
                this.getThread().setBreakpoint((MWEBreakpoint)bp);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void requireStepInto() throws DebugException {
        this.getThread().setStepping(true);
        this.cmdHandler.sendStepIntoCommand();
    }

    public void requireStepOver() throws DebugException {
        this.getThread().setStepping(true);
        this.cmdHandler.sendStepOverCommand();
    }

    public void requireStepReturn() throws DebugException {
        this.getThread().setStepping(true);
        this.cmdHandler.sendStepReturnCommand();
    }

    public void requireResume() throws DebugException {
        this.getThread().setStepping(false);
        this.cmdHandler.sendResumeCommand();
    }

    public void requireSuspend() throws DebugException {
        this.cmdHandler.sendSuspendCommand();
    }

    public void requireTerminate() throws DebugException {
        this.cmdHandler.sendTerminateCommand();
    }

    public List<VarValueTO> requireVariables(int frameId) throws DebugException {
        try {
            List<VarValueTO> vars = this.varHandler.sendRequireVariables(frameId);
            this.target.updateDebugValues(vars);
            return vars;
        }
        catch (IOException e) {
            this.handleIOProblem(e);
            return null;
        }
    }

    public List<VarValueTO> requireSubVariables(int varId) throws DebugException {
        int frameId = this.target.getThread().getVarFrameId();
        try {
            List<VarValueTO> vars = this.varHandler.sendRequireSubVariables(frameId, varId);
            this.target.updateDebugValues(vars);
            return vars;
        }
        catch (IOException e) {
            this.handleIOProblem(e);
            return null;
        }
    }

    public void requireSetBreakpoint(MWEBreakpoint bp) throws DebugException {
        try {
            this.bpHandler.sendSetBreakpoint(bp);
        }
        catch (IOException e) {
            this.handleIOProblem(e);
        }
    }

    public void requireRemoveBreakpoint(MWEBreakpoint bp) throws DebugException {
        try {
            this.bpHandler.sendRemoveBreakpoint(bp);
        }
        catch (IOException e) {
            this.handleIOProblem(e);
        }
    }

    public void handleIOProblem(Exception e) throws DebugException {
        throw new DebugException(Activator.createErrorStatus("lost connection to debugger runtime process --> aborting", e));
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this.target, 4));
    }

    private void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this.getThread(), 1, detail));
    }

    private void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this.getThread(), 2, detail));
    }

    private void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this.target, 8));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }
}

