/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.product.VersionDialog;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyCalculator;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.plugin.NewFragmentProjectWizard;
import org.eclipse.pde.internal.ui.wizards.plugin.NewPluginProjectWizard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginSection
extends TableSection
implements IPluginModelListener {
    private TableViewer fPluginTable;
    private Button fIncludeOptionalButton;
    private Action fNewPluginAction;
    private Action fNewFragmentAction;
    public static final QualifiedName OPTIONAL_PROPERTY = new QualifiedName("org.eclipse.pde.ui", "product.includeOptional");

    public PluginSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, PluginSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.Product_PluginSection_add, PDEUIMessages.Product_PluginSection_working, PDEUIMessages.Product_PluginSection_required, PDEUIMessages.PluginSection_remove, PDEUIMessages.Product_PluginSection_removeAll, PDEUIMessages.Product_FeatureSection_properties};
        return labels;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.verticalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        this.createOptionalDependenciesButton(container);
        EditableTablePart tablePart = this.getTablePart();
        this.fPluginTable = tablePart.getTableViewer();
        this.fPluginTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fPluginTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IProductPlugin p1 = (IProductPlugin)e1;
                IProductPlugin p2 = (IProductPlugin)e2;
                return super.compare(viewer, (Object)p1.getId(), (Object)p2.getId());
            }
        });
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.minimumWidth = 200;
        this.fPluginTable.setInput((Object)this.getProduct());
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable());
        tablePart.setButtonEnabled(2, this.isEditable());
        tablePart.setButtonEnabled(5, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setText(PDEUIMessages.Product_PluginSection_title);
        section.setDescription(PDEUIMessages.Product_PluginSection_desc);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.fNewPluginAction = new NewPluginAction();
        this.fNewFragmentAction = new NewFragmentAction();
        toolBarManager.add((IAction)this.fNewPluginAction);
        toolBarManager.add((IAction)this.fNewFragmentAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void createOptionalDependenciesButton(Composite container) {
        if (this.isEditable()) {
            this.fIncludeOptionalButton = new Button(container, 32);
            this.fIncludeOptionalButton.setText(PDEUIMessages.PluginSection_includeOptional);
            IEditorInput input = this.getPage().getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                try {
                    this.fIncludeOptionalButton.setSelection("true".equals(file.getPersistentProperty(OPTIONAL_PROPERTY)));
                }
                catch (CoreException coreException) {}
            }
            this.fIncludeOptionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IEditorInput input = PluginSection.this.getPage().getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)input).getFile();
                        try {
                            file.setPersistentProperty(OPTIONAL_PROPERTY, PluginSection.this.fIncludeOptionalButton.getSelection() ? "true" : null);
                        }
                        catch (CoreException coreException) {}
                    }
                }
            });
        }
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleAddWorkingSet();
                break;
            }
            case 2: {
                PluginSection.handleAddRequired(this.getProduct().getPlugins(), this.fIncludeOptionalButton.getSelection());
                break;
            }
            case 3: {
                this.handleDelete();
                break;
            }
            case 4: {
                this.handleRemoveAll();
                break;
            }
            case 5: {
                this.handleProperties();
            }
        }
    }

    private void handleNewFragment() {
        NewFragmentProjectWizard wizard = new NewFragmentProjectWizard();
        wizard.init(PDEPlugin.getActiveWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            this.addPlugin(wizard.getFragmentId(), wizard.getFragmentVersion());
        }
    }

    private void handleNewPlugin() {
        NewPluginProjectWizard wizard = new NewPluginProjectWizard();
        wizard.init(PDEPlugin.getActiveWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            this.addPlugin(wizard.getPluginId(), wizard.getPluginVersion());
        }
    }

    private void handleProperties() {
        IStructuredSelection ssel = (IStructuredSelection)this.fPluginTable.getSelection();
        if (ssel.size() == 1) {
            IProductPlugin plugin = (IProductPlugin)ssel.toArray()[0];
            VersionDialog dialog = new VersionDialog(PDEPlugin.getActiveWorkbenchShell(), this.isEditable(), plugin.getVersion());
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 200);
            if (dialog.open() == 0) {
                plugin.setVersion(dialog.getVersion());
            }
        }
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen(selection);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IProductPlugin) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection ssel = (IStructuredSelection)this.fPluginTable.getSelection();
        if (ssel == null) {
            return;
        }
        Action openAction = new Action(PDEUIMessages.PluginSection_open){

            public void run() {
                PluginSection.this.handleDoubleClick((IStructuredSelection)PluginSection.this.fPluginTable.getSelection());
            }
        };
        openAction.setEnabled(this.isEditable() && ssel.size() == 1);
        manager.add((IAction)openAction);
        manager.add((IContributionItem)new Separator());
        Action removeAction = new Action(PDEUIMessages.PluginSection_remove){

            public void run() {
                PluginSection.this.handleDelete();
            }
        };
        removeAction.setEnabled(this.isEditable() && ssel.size() > 0);
        manager.add((IAction)removeAction);
        Action removeAll = new Action(PDEUIMessages.PluginSection_removeAll){

            public void run() {
                PluginSection.this.handleRemoveAll();
            }
        };
        removeAll.setEnabled(this.isEditable());
        manager.add((IAction)removeAll);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleOpen(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof IProductPlugin) {
            ManifestEditor.openPluginEditor(((IProductPlugin)object).getId());
        }
    }

    public static void handleAddRequired(IProductPlugin[] plugins, boolean includeOptional) {
        if (plugins.length == 0) {
            return;
        }
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>(plugins.length);
        int i = 0;
        while (i < plugins.length) {
            list.add(TargetPlatformHelper.getState().getBundle(plugins[i].getId(), null));
            ++i;
        }
        DependencyCalculator calculator = new DependencyCalculator(includeOptional);
        calculator.findDependencies(list.toArray());
        BundleDescription[] bundles = TargetPlatformHelper.getState().getBundles();
        int i2 = 0;
        while (i2 < bundles.length) {
            HostSpecification host = bundles[i2].getHost();
            if (host != null && !"org.eclipse.ui.workbench.compatibility".equals(bundles[i2].getSymbolicName()) && calculator.containsPluginId(host.getName())) {
                calculator.findDependency(bundles[i2]);
            }
            ++i2;
        }
        Set dependencies = calculator.getBundleIDs();
        IProduct product = plugins[0].getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductPlugin[] requiredPlugins = new IProductPlugin[dependencies.size()];
        int i3 = 0;
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            String id = iter.next().toString();
            IProductPlugin plugin = factory.createPlugin();
            plugin.setId(id);
            requiredPlugins[i3++] = plugin;
        }
        product.addPlugins(requiredPlugins);
    }

    private void handleAddWorkingSet() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), true);
        if (dialog.open() == 0) {
            IWorkingSet[] workingSets = dialog.getSelection();
            IProduct product = this.getProduct();
            IProductModelFactory factory = product.getModel().getFactory();
            ArrayList<IProductPlugin> pluginList = new ArrayList<IProductPlugin>();
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IPluginModelBase model = this.findModel(elements[j]);
                    if (model != null) {
                        IProductPlugin plugin = factory.createPlugin();
                        IPluginBase base = model.getPluginBase();
                        plugin.setId(base.getId());
                        pluginList.add(plugin);
                    }
                    ++j;
                }
                ++i;
            }
            product.addPlugins(pluginList.toArray(new IProductPlugin[pluginList.size()]));
        }
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removePlugins(product.getPlugins());
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fPluginTable.getSelection();
        if (ssel.size() > 0) {
            Object[] objects = ssel.toArray();
            IProductPlugin[] plugins = new IProductPlugin[objects.length];
            System.arraycopy(objects, 0, plugins, 0, objects.length);
            this.getProduct().removePlugins(plugins);
        }
    }

    private void handleAdd() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        dialog.setElements((Object[])this.getBundles());
        dialog.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        dialog.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            Object[] bundles = dialog.getResult();
            int i = 0;
            while (i < bundles.length) {
                BundleDescription desc = (BundleDescription)bundles[i];
                this.addPlugin(desc.getSymbolicName(), "0.0.0");
                ++i;
            }
        }
    }

    private BundleDescription[] getBundles() {
        TreeMap<String, BundleDescription> map = new TreeMap<String, BundleDescription>();
        IProduct product = this.getProduct();
        BundleDescription[] bundles = TargetPlatformHelper.getState().getBundles();
        int i = 0;
        while (i < bundles.length) {
            String id = bundles[i].getSymbolicName();
            if (!product.containsPlugin(id)) {
                map.put(id, bundles[i]);
            }
            ++i;
        }
        return map.values().toArray(new BundleDescription[map.size()]);
    }

    private void addPlugin(String id, String version) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductPlugin plugin = factory.createPlugin();
        plugin.setId(id);
        plugin.setVersion(version);
        product.addPlugins(new IProductPlugin[]{plugin});
        this.fPluginTable.setSelection((ISelection)new StructuredSelection((Object)plugin));
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        Object[] objects = e.getChangedObjects();
        if (e.getChangeType() == 1) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductPlugin) {
                    this.fPluginTable.add(objects[i]);
                }
                ++i;
            }
        } else if (e.getChangeType() == 2) {
            Table table = this.fPluginTable.getTable();
            int index = table.getSelectionIndex();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductPlugin) {
                    this.fPluginTable.remove(objects[i]);
                }
                ++i;
            }
            int count = table.getItemCount();
            if (count != 0) {
                if (index < count) {
                    table.setSelection(index);
                } else {
                    table.setSelection(count - 1);
                }
            }
        } else if (e.getChangeType() == 3) {
            this.fPluginTable.refresh();
        }
        this.updateRemoveButtons(false, true);
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        if (this.fPluginTable.getTable().isDisposed()) {
            return;
        }
        this.fPluginTable.setInput((Object)this.getProduct());
        this.refresh();
    }

    public void refresh() {
        this.fPluginTable.refresh();
        this.updateRemoveButtons(true, true);
        super.refresh();
    }

    public void modelsChanged(PluginModelDelta delta) {
        final Control control = this.fPluginTable.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        PluginSection.this.fPluginTable.refresh();
                        PluginSection.this.updateRemoveButtons(true, true);
                    }
                }
            });
        }
    }

    private IPluginModelBase findModel(IAdaptable object) {
        if (object instanceof IJavaProject) {
            object = ((IJavaProject)object).getProject();
        }
        if (object instanceof IProject) {
            return PluginRegistry.findModel((IProject)((IProject)object));
        }
        if (object instanceof PersistablePluginObject) {
            return PluginRegistry.findModel((String)((PersistablePluginObject)object).getPluginID());
        }
        return null;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateRemoveButtons(true, false);
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IProductPlugin) {
            this.fPluginTable.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    protected void doPaste(Object target, Object[] objects) {
        IProductPlugin[] plugins;
        if (objects instanceof IProductPlugin[]) {
            plugins = (IProductPlugin[])objects;
        } else {
            plugins = new IProductPlugin[objects.length];
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductPlugin) {
                    plugins[i] = (IProductPlugin)objects[i];
                }
                ++i;
            }
        }
        this.getProduct().addPlugins(plugins);
    }

    private void updateRemoveButtons(boolean updateRemove, boolean updateRemoveAll) {
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        if (updateRemove) {
            ISelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(3, this.isEditable() && !selection.isEmpty() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IProductPlugin);
        }
        int count = this.fPluginTable.getTable().getItemCount();
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(4, this.isEditable() && count > 0);
        }
        tablePart.setButtonEnabled(2, this.isEditable() && count > 0);
        tablePart.setButtonEnabled(5, this.isEditable() && tableSelection.length == 1);
    }

    protected boolean createCount() {
        return true;
    }

    public boolean includeOptionalDependencies() {
        return this.fIncludeOptionalButton.getSelection();
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PluginSection.this.getProduct().getPlugins();
        }
    }

    class NewFragmentAction
    extends Action {
        public NewFragmentAction() {
            super(PDEUIMessages.Product_PluginSection_newFragment, 1);
            this.setImageDescriptor(PDEPluginImages.DESC_NEWFRAGPRJ_TOOL);
        }

        public void run() {
            PluginSection.this.handleNewFragment();
        }
    }

    class NewPluginAction
    extends Action {
        public NewPluginAction() {
            super(PDEUIMessages.Product_PluginSection_newPlugin, 1);
            this.setImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_TOOL);
        }

        public void run() {
            PluginSection.this.handleNewPlugin();
        }
    }
}

