/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.ModelChange;
import org.eclipse.pde.internal.ui.nls.ModelChangeElement;
import org.eclipse.pde.internal.ui.nls.ModelChangeFile;
import org.eclipse.pde.internal.ui.nls.StringHelper;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExternalizeStringsOperation
extends WorkspaceModifyOperation {
    private Object[] fChangeFiles;
    private CompositeChange fParentChange;
    private HashMap fCompositeChanges;
    private HashMap fFileChanges;

    public ExternalizeStringsOperation(Object[] changeFiles, CompositeChange parentChange) {
        this.fChangeFiles = changeFiles;
        this.fParentChange = parentChange;
        this.fCompositeChanges = new HashMap();
        this.fFileChanges = new HashMap();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        int i = 0;
        while (i < this.fChangeFiles.length) {
            block10: {
                if (this.fChangeFiles[i] instanceof ModelChangeFile) {
                    IFile buildProps;
                    ModelChangeFile changeFile = (ModelChangeFile)this.fChangeFiles[i];
                    CompositeChange pluginChange = this.getChangeForPlugin(changeFile.getModel().getParentModel().getPluginBase().getId());
                    ModelChange change = changeFile.getModel();
                    IFile pFile = change.getPropertiesFile();
                    if (!pFile.exists() && !this.fFileChanges.containsKey(pFile)) {
                        TextFileChange fileChange = this.getChangeForFile(pFile, pluginChange);
                        InsertEdit edit = new InsertEdit(0, ExternalizeStringsOperation.getPropertiesFileComment(pFile));
                        fileChange.getEdit().addChild((TextEdit)edit);
                        fileChange.addTextEditGroup(new TextEditGroup(PDEUIMessages.ExternalizeStringsOperation_editNames_addComment, (TextEdit)edit));
                    }
                    if (!change.localizationSet()) {
                        this.addBundleLocalization(change, monitor, pluginChange);
                    }
                    if ((buildProps = PDEProject.getBuildProperties((IProject)changeFile.getFile().getProject())) != null && buildProps.exists() && !this.fFileChanges.containsKey(buildProps)) {
                        this.getChangeForBuild(buildProps, monitor, pluginChange, change.getBundleLocalization());
                    }
                    ITextFileBufferManager pManager = FileBuffers.getTextFileBufferManager();
                    try {
                        try {
                            pManager.connect(pFile.getFullPath(), LocationKind.IFILE, monitor);
                            ITextFileBuffer pBuffer = pManager.getTextFileBuffer(pFile.getFullPath(), LocationKind.IFILE);
                            IDocument pDoc = pBuffer.getDocument();
                            TextFileChange pChange = this.getChangeForFile(pFile, pluginChange);
                            this.doReplace(changeFile, pDoc, pChange, monitor, pluginChange);
                        }
                        catch (MalformedTreeException malformedTreeException) {
                            pManager.disconnect(pFile.getFullPath(), LocationKind.IFILE, monitor);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        pManager.disconnect(pFile.getFullPath(), LocationKind.IFILE, monitor);
                        throw throwable;
                    }
                    pManager.disconnect(pFile.getFullPath(), LocationKind.IFILE, monitor);
                }
            }
            ++i;
        }
    }

    private void getChangeForBuild(IFile buildPropsFile, IProgressMonitor monitor, CompositeChange parent, final String localization) {
        TextFileChange[] changes = PDEModelUtility.changesForModelModication(new ModelModification(buildPropsFile){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBuildModel) {
                    IBuildModel buildModel = (IBuildModel)model;
                    IBuildEntry binIncludes = buildModel.getBuild().getEntry("bin.includes");
                    if (binIncludes == null) {
                        binIncludes = buildModel.getFactory().createEntry("bin.includes");
                    }
                    binIncludes.addToken(String.valueOf(localization) + ".properties");
                }
            }
        }, monitor);
        if (changes.length > 0 && changes[0] != null) {
            this.fFileChanges.put(buildPropsFile, changes[0]);
            parent.add((Change)changes[0]);
        }
    }

    private CompositeChange getChangeForPlugin(String pluginName) {
        if (this.fCompositeChanges.containsKey(pluginName)) {
            return (CompositeChange)this.fCompositeChanges.get(pluginName);
        }
        CompositeChange result = new CompositeChange(NLS.bind((String)PDEUIMessages.ExternalizeStringsOperation_pluginChangeName, (Object)pluginName));
        this.fCompositeChanges.put(pluginName, result);
        this.fParentChange.add((Change)result);
        return result;
    }

    private TextFileChange getChangeForFile(IFile file, CompositeChange parentChange) {
        if (this.fFileChanges.containsKey(file)) {
            return (TextFileChange)this.fFileChanges.get(file);
        }
        MultiTextEdit edit = new MultiTextEdit();
        TextFileChange change = new TextFileChange(file.getName(), file);
        change.setEdit((TextEdit)edit);
        String textType = file.getName().equals("plugin.xml") || file.getName().equals("fragment.xml") ? "PLUGIN2" : file.getFileExtension();
        change.setTextType(textType);
        parentChange.add((Change)change);
        this.fFileChanges.put(file, change);
        return change;
    }

    private void doReplace(ModelChangeFile changeFile, IDocument pDoc, TextFileChange pChange, IProgressMonitor monitor, CompositeChange parentChange) throws CoreException {
        IFile uFile = changeFile.getFile();
        try {
            TextFileChange uChange = this.getChangeForFile(uFile, parentChange);
            Iterator iter = changeFile.getChanges().iterator();
            while (iter.hasNext()) {
                ModelChangeElement changeElement = (ModelChangeElement)iter.next();
                if (!changeElement.isExternalized()) continue;
                ReplaceEdit uEdit = new ReplaceEdit(changeElement.getOffset(), changeElement.getLength(), changeElement.getExternKey());
                uChange.getEdit().addChild((TextEdit)uEdit);
                uChange.addTextEditGroup(new TextEditGroup(NLS.bind((String)PDEUIMessages.ExternalizeStringsOperation_editNames_replaceText, (Object)changeElement.getKey()), (TextEdit)uEdit));
                InsertEdit pEdit = ExternalizeStringsOperation.getPropertiesInsertEdit(pDoc, changeElement);
                pChange.getEdit().addChild((TextEdit)pEdit);
                pChange.addTextEditGroup(new TextEditGroup(NLS.bind((String)PDEUIMessages.ExternalizeStringsOperation_editNames_insertProperty, (Object)changeElement.getKey()), (TextEdit)pEdit));
            }
        }
        catch (MalformedTreeException malformedTreeException) {}
    }

    private void addBundleLocalization(ModelChange change, IProgressMonitor mon, CompositeChange parent) {
        IPluginModelBase base = change.getParentModel();
        IFile manifest = PDEProject.getManifest((IProject)base.getUnderlyingResource().getProject());
        if (this.fFileChanges.containsKey(manifest)) {
            return;
        }
        final String localiz = change.getBundleLocalization();
        TextFileChange[] result = PDEModelUtility.changesForModelModication(new ModelModification(manifest){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    IBundlePluginModelBase bundleModel = (IBundlePluginModelBase)model;
                    IBundle bundle = bundleModel.getBundleModel().getBundle();
                    bundle.setLocalization(localiz);
                }
            }
        }, mon);
        if (result.length > 0 && result[0] != null) {
            this.fFileChanges.put(manifest, result[0]);
            parent.add((Change)result[0]);
        }
    }

    public static InsertEdit getPropertiesInsertEdit(IDocument doc, ModelChangeElement element) {
        String nl = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        StringBuffer sb = new StringBuffer(nl);
        sb.append(element.getKey());
        sb.append(" = ");
        sb.append(StringHelper.preparePropertiesString(element.getValue(), nl.toCharArray()));
        return new InsertEdit(doc.getLength(), sb.toString());
    }

    public static String getPropertiesFileComment(IFile file) {
        IPluginBase pluginBase;
        IPluginModelBase model = PluginRegistry.findModel((IProject)file.getProject());
        if (model != null && (pluginBase = model.getPluginBase()) != null) {
            return NLS.bind((String)"#Properties file for {0}", (Object)pluginBase.getId());
        }
        return NLS.bind((String)"#{0}", (Object)file.getName());
    }
}

