/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.ILifeCycle;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;

class PhaseListenerManager {
    private final ILifeCycle eventSource;
    private final Object lock;
    private final Set phaseListeners;

    public PhaseListenerManager(ILifeCycle eventSource) {
        this.eventSource = eventSource;
        this.lock = new Object();
        this.phaseListeners = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPhaseListener(PhaseListener phaseListener) {
        ParamCheck.notNull(phaseListener, "phaseListener");
        Object object = this.lock;
        synchronized (object) {
            this.phaseListeners.add(phaseListener);
        }
    }

    void addPhaseListeners(PhaseListener[] phaseListeners) {
        ParamCheck.notNull(phaseListeners, "phaseListeners");
        int i = 0;
        while (i < phaseListeners.length) {
            this.addPhaseListener(phaseListeners[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePhaseListener(PhaseListener phaseListener) {
        ParamCheck.notNull(phaseListener, "phaseListener");
        Object object = this.lock;
        synchronized (object) {
            this.phaseListeners.remove(phaseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PhaseListener[] getPhaseListeners() {
        Object object = this.lock;
        synchronized (object) {
            PhaseListener[] result = new PhaseListener[this.phaseListeners.size()];
            this.phaseListeners.toArray(result);
            return result;
        }
    }

    void notifyBeforePhase(PhaseId phase) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        PhaseEvent event = new PhaseEvent(this.eventSource, phase);
        int i = 0;
        while (i < phaseListeners.length) {
            PhaseListener phaseListener = phaseListeners[i];
            if (PhaseListenerManager.mustNotify(phase, phaseListener.getPhaseId())) {
                try {
                    phaseListener.beforePhase(event);
                }
                catch (Exception exception) {
                    PhaseListenerManager.logBeforePhaseException(phase, exception);
                }
            }
            ++i;
        }
    }

    void notifyAfterPhase(PhaseId phase) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        PhaseEvent event = new PhaseEvent(this.eventSource, phase);
        int i = 0;
        while (i < phaseListeners.length) {
            PhaseListener phaseListener = phaseListeners[i];
            if (PhaseListenerManager.mustNotify(phase, phaseListener.getPhaseId())) {
                try {
                    phaseListener.afterPhase(event);
                }
                catch (Exception exception) {
                    PhaseListenerManager.logAfterPhaseException(phase, exception);
                }
            }
            ++i;
        }
    }

    private static boolean mustNotify(PhaseId phase, PhaseId listenerPhase) {
        return listenerPhase == PhaseId.ANY || listenerPhase == phase;
    }

    private static void logBeforePhaseException(PhaseId phase, Exception exception) {
        String text = "Failed to execute PhaseListener before phase ''{0}''.";
        String msg = MessageFormat.format(text, phase);
        ServletLog.log(msg, exception);
    }

    private static void logAfterPhaseException(PhaseId phase, Exception exception) {
        String text = "Failed to execute PhaseListener after phase ''{0}''.";
        String msg = MessageFormat.format(text, phase);
        ServletLog.log(msg, exception);
    }
}

