/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.IPhase;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.lifecycle.PhaseExecutor;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerManager;
import org.eclipse.rwt.internal.lifecycle.PrepareUIRoot;
import org.eclipse.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rwt.internal.lifecycle.ReadData;
import org.eclipse.rwt.internal.lifecycle.Render;
import org.eclipse.rwt.internal.lifecycle.Scope;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public class SimpleLifeCycle
extends LifeCycle {
    private static final IPhase[] PHASES = new IPhase[]{new PrepareUIRoot(), new ReadData(), new ProcessAction(), new Render()};
    private final PhaseListenerManager phaseListenerManager = new PhaseListenerManager(this);
    static /* synthetic */ Class class$0;

    public SimpleLifeCycle() {
        this.phaseListenerManager.addPhaseListeners(RWTFactory.getPhaseListenerRegistry().get());
    }

    public Scope getScope() {
        return Scope.APPLICATION;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws IOException {
        SimpleLifeCycle.attachThread();
        try {
            SessionDisplayPhaseExecutor phaseExecutor = new SessionDisplayPhaseExecutor(this.phaseListenerManager);
            phaseExecutor.execute(PhaseId.PREPARE_UI_ROOT);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            SimpleLifeCycle.detachThread();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        SimpleLifeCycle.detachThread();
    }

    public void requestThreadExec(Runnable runnable) {
        runnable.run();
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        this.phaseListenerManager.addPhaseListener(phaseListener);
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        this.phaseListenerManager.removePhaseListener(phaseListener);
    }

    private static void attachThread() {
        IDisplayAdapter displayAdapter = SimpleLifeCycle.getDisplayAdapter();
        if (displayAdapter != null) {
            displayAdapter.attachThread();
        }
        SimpleUIThreadHolder uiThreadHolder = new SimpleUIThreadHolder(Thread.currentThread());
        LifeCycleUtil.setUIThread(RWT.getSessionStore(), uiThreadHolder);
    }

    private static void detachThread() {
        IDisplayAdapter displayAdapter = SimpleLifeCycle.getDisplayAdapter();
        if (displayAdapter != null) {
            displayAdapter.detachThread();
        }
        LifeCycleUtil.setUIThread(RWT.getSessionStore(), null);
    }

    private static IDisplayAdapter getDisplayAdapter() {
        IDisplayAdapter result = null;
        Display display = LifeCycleUtil.getSessionDisplay();
        if (display != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (IDisplayAdapter)display.getAdapter(clazz);
        }
        return result;
    }

    private static class SessionDisplayPhaseExecutor
    extends PhaseExecutor {
        SessionDisplayPhaseExecutor(PhaseListenerManager phaseListenerManager) {
            super(phaseListenerManager, PHASES);
        }

        Display getDisplay() {
            return LifeCycleUtil.getSessionDisplay();
        }
    }

    private static class SimpleUIThreadHolder
    implements IUIThreadHolder {
        private final Thread thread;

        public SimpleUIThreadHolder(Thread thread) {
            this.thread = thread;
        }

        public void updateServiceContext() {
        }

        public void terminateThread() {
        }

        public void switchThread() {
        }

        public void setServiceContext(ServiceContext serviceContext) {
        }

        public Thread getThread() {
            return this.thread;
        }

        public Object getLock() {
            return null;
        }
    }
}

