/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.text.MessageFormat;
import org.eclipse.rwt.internal.lifecycle.UITestUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public final class WidgetUtil {
    public static final String CUSTOM_VARIANT = "org.eclipse.rwt.themeVariant";
    public static final String CUSTOM_WIDGET_ID = "org.eclipse.rwt.UITests#customId";
    public static final String ENABLE_UI_TESTS = "org.eclipse.rwt.enableUITests";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private WidgetUtil() {
    }

    public static IWidgetAdapter getAdapter(Widget widget) {
        IWidgetAdapter result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.IWidgetAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (IWidgetAdapter)widget.getAdapter(clazz)) == null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.rwt.lifecycle.IWidgetAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            WidgetUtil.throwAdapterException(clazz2);
        }
        return result;
    }

    public static String getId(Widget widget) {
        String result = null;
        if (UITestUtil.isEnabled()) {
            result = (String)widget.getData(CUSTOM_WIDGET_ID);
        }
        if (result == null) {
            result = WidgetUtil.getAdapter(widget).getId();
        }
        return result;
    }

    public static String getVariant(Widget widget) {
        String result = null;
        WidgetAdapter widgetAdapter = (WidgetAdapter)WidgetUtil.getAdapter(widget);
        Object data = widget.getData(CUSTOM_VARIANT);
        if (data instanceof String && !(result = (String)data).equals(widgetAdapter.getCachedVariant())) {
            if (WidgetUtil.validateVariantString(result)) {
                widgetAdapter.setCachedVariant(result);
            } else {
                String pattern = "Illegal character in widget variant ''{0}''";
                Object[] arguments = new Object[]{result};
                String message = MessageFormat.format(pattern, arguments);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static AbstractWidgetLCA getLCA(Widget widget) {
        Class<?> clazz;
        AbstractWidgetLCA result;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.rwt.lifecycle.ILifeCycleAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (AbstractWidgetLCA)widget.getAdapter(clazz = clazz2)) == null) {
            WidgetUtil.throwAdapterException(clazz);
        }
        return result;
    }

    public static Widget find(Composite root, final String id) {
        final Widget[] result = new Widget[1];
        if (id != null) {
            WidgetTreeVisitor.accept(root, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    if (WidgetUtil.getId(widget).equals(id)) {
                        result[0] = widget;
                    }
                    return result[0] == null;
                }
            });
        }
        return result[0];
    }

    private static void throwAdapterException(Class clazz) {
        String text = "Could not retrieve an instance of ''{0}''. Probably the AdapterFactory was not properly registered.";
        Object[] param = new Object[]{clazz.getName()};
        String msg = MessageFormat.format(text, param);
        throw new IllegalStateException(msg);
    }

    private static boolean validateVariantString(String variant) {
        int length;
        boolean result = false;
        String name = variant;
        if (name.startsWith("-")) {
            name = name.substring(1);
        }
        if ((length = name.length()) > 0) {
            result = WidgetUtil.isValidStart(name.charAt(0));
            int i = 1;
            while (i < length && result) {
                result &= WidgetUtil.isValidPart(name.charAt(i));
                ++i;
            }
        }
        return result;
    }

    private static boolean isValidStart(char ch) {
        return ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '\u0080' && ch <= '\u00ff';
    }

    private static boolean isValidPart(char ch) {
        return WidgetUtil.isValidStart(ch) || ch >= '0' && ch <= '9' || ch == '-';
    }
}

