/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.ISettingStore;
import org.eclipse.rwt.service.SettingStoreEvent;
import org.eclipse.rwt.service.SettingStoreException;
import org.eclipse.rwt.service.SettingStoreListener;

public final class FileSettingStore
implements ISettingStore {
    public static final String FILE_SETTING_STORE_DIR = "org.eclipse.rwt.service.FileSettingStore.dir";
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private final File workDir;
    private final Properties props = new Properties();
    private final Set listeners = new HashSet();
    private String id;
    static /* synthetic */ Class class$0;

    public FileSettingStore(File workDir) {
        ParamCheck.notNull(workDir, "workDir");
        if (!workDir.isDirectory()) {
            String msg = "workDir is not a directory: " + workDir;
            throw new IllegalArgumentException(msg);
        }
        this.workDir = workDir;
        this.id = String.valueOf(String.valueOf(System.currentTimeMillis())) + "_" + RANDOM.nextInt(Short.MAX_VALUE);
    }

    public String getId() {
        return this.id;
    }

    public synchronized String getAttribute(String name) {
        ParamCheck.notNull(name, "name");
        return this.props.getProperty(name);
    }

    public synchronized void setAttribute(String name, String value) throws SettingStoreException {
        ParamCheck.notNull(name, "name");
        if (value == null) {
            this.removeAttribute(name);
        } else {
            String oldValue = (String)this.props.setProperty(name, value);
            if (!value.equals(oldValue)) {
                this.notifyListeners(name, oldValue, value);
                this.persist();
            }
        }
    }

    public synchronized Enumeration getAttributeNames() {
        return this.props.keys();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void loadById(String id) throws SettingStoreException {
        ParamCheck.notNullOrEmpty(id, "id");
        this.id = id;
        this.notifyForEachAttribute(true);
        this.props.clear();
        BufferedInputStream bis = this.getInputStream(id);
        if (bis == null) return;
        try {
            try {
                this.props.load(bis);
                this.notifyForEachAttribute(false);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                bis.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                bis.close();
                return;
            }
        }
        catch (IOException ioe) {
            String msg = "Failed to load into file setting store; id= " + id;
            throw new SettingStoreException(msg, ioe);
        }
    }

    public synchronized void removeAttribute(String name) throws SettingStoreException {
        String oldValue = (String)this.props.remove(name);
        if (oldValue != null) {
            this.notifyListeners(name, oldValue, null);
            this.persist();
        }
    }

    public synchronized void addSettingStoreListener(SettingStoreListener listener) {
        ParamCheck.notNull(listener, "listener");
        this.listeners.add(listener);
    }

    public synchronized void removeSettingStoreListener(SettingStoreListener listener) {
        ParamCheck.notNull(listener, "listener");
        this.listeners.remove(listener);
    }

    private BufferedInputStream getInputStream(String streamId) {
        BufferedInputStream result = null;
        File file = this.getStoreFile(streamId);
        if (file.exists()) {
            try {
                result = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fnf) {
                this.log("Should not happen", fnf);
            }
        }
        return result;
    }

    private BufferedOutputStream getOutputStream(String streamId) throws FileNotFoundException {
        File file = this.getStoreFile(streamId);
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private File getStoreFile(String fileName) {
        return new File(this.workDir, fileName);
    }

    private void log(String msg, Throwable throwable) {
        RWT.getRequest().getSession().getServletContext().log(msg, throwable);
    }

    private synchronized void notifyForEachAttribute(boolean removed) {
        Enumeration<Object> attributes = this.props.keys();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            String value = this.props.getProperty(attribute);
            if (removed) {
                this.notifyListeners(attribute, value, null);
                continue;
            }
            this.notifyListeners(attribute, null, value);
        }
    }

    private synchronized void notifyListeners(String attribute, String oldValue, String newValue) {
        SettingStoreEvent event = new SettingStoreEvent(this, attribute, oldValue, newValue);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            String msg;
            SettingStoreListener listener = (SettingStoreListener)iter.next();
            try {
                listener.settingChanged(event);
            }
            catch (Exception exc) {
                msg = "Exception when invoking listener " + listener.getClass().getName();
                this.log(msg, exc);
            }
            catch (LinkageError le) {
                msg = "Linkage error when invoking listener " + listener.getClass().getName();
                this.log(msg, le);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persist() throws SettingStoreException {
        try {
            BufferedOutputStream bos = this.getOutputStream(this.id);
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.rwt.service.FileSettingStore");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                this.props.store(bos, clazz.getName());
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                bos.close();
                throw throwable;
            }
            {
                Object var2_5 = null;
                bos.close();
                return;
            }
        }
        catch (IOException ioe) {
            String msg = "Failed to persist file setting store; id= " + this.id;
            throw new SettingStoreException(msg, ioe);
        }
    }
}

