/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.widgets.Widget;

public class DropTargetEvent
extends TypedEvent {
    private static final long serialVersionUID = 1L;
    public static final int DRAG_ENTER = 2002;
    public static final int DRAG_OVER = 2004;
    public static final int DRAG_LEAVE = 2003;
    public static final int DROP_ACCEPT = 2007;
    public static final int DROP = 2006;
    public static final int DRAG_OPERATION_CHANGED = 2005;
    private static final Class LISTENER;
    public int x;
    public int y;
    public int detail;
    public int operations;
    public int feedback;
    public Widget item;
    public TransferData currentDataType;
    public TransferData[] dataTypes;
    public int time;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTargetListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LISTENER = clazz;
    }

    public DropTargetEvent(Widget widget, int id) {
        super(widget, id);
    }

    public String toString() {
        String string = super.toString();
        StringBuffer sb = new StringBuffer();
        sb.append(string.substring(0, string.length() - 1));
        sb.append(" x=");
        sb.append(this.x);
        sb.append(" y=");
        sb.append(this.y);
        sb.append(" item=");
        sb.append(this.item);
        sb.append(" operations=");
        sb.append(this.operations);
        sb.append(" operation=");
        sb.append(this.detail);
        sb.append(" feedback=");
        sb.append(this.feedback);
        sb.append(" dataTypes={ ");
        if (this.dataTypes != null) {
            int i = 0;
            while (i < this.dataTypes.length) {
                sb.append(this.dataTypes[i].type);
                sb.append(' ');
                ++i;
            }
        }
        sb.append('}');
        sb.append(" currentDataType=");
        sb.append(this.currentDataType != null ? this.currentDataType.type : 48);
        sb.append('}');
        return sb.toString();
    }

    protected void dispatchToObserver(Object listener) {
        switch (this.getID()) {
            case 2002: {
                ((DropTargetListener)listener).dragEnter(this);
                break;
            }
            case 2004: {
                ((DropTargetListener)listener).dragOver(this);
                break;
            }
            case 2003: {
                ((DropTargetListener)listener).dragLeave(this);
                break;
            }
            case 2007: {
                ((DropTargetListener)listener).dropAccept(this);
                break;
            }
            case 2006: {
                ((DropTargetListener)listener).drop(this);
                break;
            }
            case 2005: {
                ((DropTargetListener)listener).dragOperationChanged(this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event handler type.");
            }
        }
    }

    protected boolean allowProcessing() {
        return EventUtil.isAccessible(this.widget);
    }

    protected Class getListenerType() {
        return LISTENER;
    }

    public static boolean hasListener(Adaptable adaptable) {
        return DropTargetEvent.hasListener(adaptable, LISTENER);
    }

    public static void addListener(Adaptable adaptable, DropTargetListener listener) {
        DropTargetEvent.addListener(adaptable, LISTENER, listener);
    }

    public static void removeListener(Adaptable adaptable, DropTargetListener listener) {
        DropTargetEvent.removeListener(adaptable, LISTENER, listener);
    }

    public static Object[] getListeners(Adaptable adaptable) {
        return DropTargetEvent.getListener(adaptable, LISTENER);
    }
}

