/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.internal.lifecycle.UICallBackManager;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messageCount;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;
    static final int GROW_SIZE = 4;
    static final int MESSAGE_LIMIT = 64;
    static final boolean IS_CARBON = "carbon".equals(SWT.getPlatform());
    static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    public Synchronizer(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(RunnableLock lock) {
        boolean wake = false;
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messageCount == this.messages.length) {
                RunnableLock[] newMessages = new RunnableLock[this.messageCount + 4];
                System.arraycopy(this.messages, 0, newMessages, 0, this.messageCount);
                this.messages = newMessages;
            }
            this.messages[this.messageCount++] = lock;
            if (this.messageCount == 1) {
                UICallBack.runNonUIThreadWithFakeContext(this.display, new Runnable(){

                    public void run() {
                        UICallBackManager.getInstance().setHasRunnables(true);
                    }
                });
            }
            wake = this.messageCount == 1;
        }
        if (wake) {
            this.display.wakeThread();
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable == null && !IS_CARBON && !IS_GTK) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMessageCount() {
        Object object = this.messageLock;
        synchronized (object) {
            return this.messageCount;
        }
    }

    void releaseSynchronizer() {
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            block6: {
                if (this.messageCount != 0) break block6;
                return null;
            }
            RunnableLock lock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0 && this.messages.length > 64) {
                this.messages = null;
            }
            if (this.messageCount == 0) {
                UICallBack.runNonUIThreadWithFakeContext(this.display, new Runnable(){

                    public void run() {
                        UICallBackManager.getInstance().setHasRunnables(false);
                    }
                });
            }
            return lock;
        }
    }

    boolean runAsyncMessages() {
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runAsyncMessages(boolean all) {
        boolean run = false;
        do {
            RunnableLock lock;
            if ((lock = this.removeFirst()) == null) {
                return run;
            }
            run = true;
            RunnableLock runnableLock = lock;
            synchronized (runnableLock) {
                Object var6_7;
                this.syncThread = lock.thread;
                try {
                    try {
                        lock.run();
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        lock.throwable = t;
                        SWT.error(46, t);
                    }
                    var6_7 = null;
                    this.syncThread = null;
                    lock.notifyAll();
                }
                catch (Throwable throwable) {
                    var6_7 = null;
                    this.syncThread = null;
                    lock.notifyAll();
                    throw throwable;
                }
            }
        } while (all);
        return run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncExec(Runnable runnable) {
        RunnableLock lock = null;
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            if (this.display == null || this.display.isDisposed()) {
                SWT.error(45);
            }
            if (!this.display.isValidThread()) {
                if (runnable == null) {
                    this.display.wake();
                    return;
                }
                lock = new RunnableLock(runnable);
                lock.thread = Thread.currentThread();
                this.addLast(lock);
            }
        }
        if (lock == null) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        object = lock;
        synchronized (object) {
            boolean interrupted = false;
            while (!lock.done()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Compatibility.interrupt();
            }
            if (lock.throwable != null) {
                SWT.error(46, lock.throwable);
            }
        }
    }
}

