/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.PrePostAsserts;
import org.eclipse.amp.amf.acore.edit.commands.test.PrePostCondition;
import org.eclipse.emf.common.command.Command;
import org.metaabm.SContext;
import org.metaabm.tests.Transformer;

public abstract class CommandTransformer
extends PrePostCondition
implements Transformer,
PrePostAsserts {
    String name;
    List<PrePostCondition> conditions;
    Map<SContext, Command> commandForModel = new HashMap<SContext, Command>();

    public CommandTransformer(String name) {
        this.name = name;
    }

    public CommandTransformer() {
        this("");
    }

    public void prepare(SContext target) {
        this.model = target;
        if (this.conditions == null) {
            this.conditions = new ArrayList<PrePostCondition>();
            this.addPrePost(this.conditions);
        }
    }

    public void doPreCondition() {
        this.preCondition();
        for (PrePostCondition condition : this.conditions) {
            condition.setDomain(this.domain);
            condition.setModel(this.model);
            condition.setTestCase(this.t);
            condition.preCondition();
        }
    }

    public void doPostCondition() {
        this.postCondition();
        for (PrePostCondition condition : this.conditions) {
            condition.setDomain(this.domain);
            condition.setModel(this.model);
            condition.setTestCase(this.t);
            condition.postCondition();
        }
    }

    public void exec() {
        this.doPreCondition();
        if (this.commandForModel.get(this.getModel()) != null) {
            CommandTest.fail();
        }
        Command command = this.getCommand();
        this.commandForModel.put(this.getModel(), command);
        command.execute();
        this.doPostCondition();
    }

    public void undo() {
        this.doPostCondition();
        this.commandForModel.get(this.getModel()).undo();
        this.doPreCondition();
    }

    public void redo() {
        this.doPreCondition();
        this.commandForModel.get(this.getModel()).redo();
        this.doPostCondition();
    }

    public void addPrePost(List<PrePostCondition> list) {
    }

    public abstract Command getCommand();

    public String toString() {
        String desc;
        Command command = this.commandForModel.get(this.getModel());
        String string = command != null ? String.valueOf(command.getLabel()) + "  " + (this.name != null ? String.valueOf(this.name) + "Name: " : "") + command.getDescription() : (desc = "Unknown Command");
        if (command.canExecute()) {
            desc = String.valueOf(desc) + (command.getAffectedObjects() == null ? "No Affected" : "Affected: ");
            for (Object object : command.getAffectedObjects()) {
                desc = String.valueOf(desc) + object.toString();
            }
        } else {
            desc = String.valueOf(desc) + "*Can't Execute*";
        }
        return desc;
    }

    public boolean modifies() {
        return true;
    }
}

