/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters095.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.4", "output_model_version=0.9.5"}, service={IConverter.class})
public class StimuliConverter
extends AbstractConverter {
    private static final String CLOCK = "clock";
    private static final String OLD_DEFINITION_V0_9_4 = "old_definition_v0.9.4";
    private static final String AM = "am";
    private static final String XSI = "xsi";
    private static final String VALUE = "value";
    private static final String UNIT = "unit";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.4 to 0.9.5 : Executing Stimuli converter for model file : {0}", new Object[]{targetFile.getName()});
        this.basicConvert(targetFile, filename2documentMap);
    }

    public void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateScenario(rootElement);
        this.updateClocksMulitplierList(rootElement);
        this.updateClockSineFunction(rootElement);
        this.updateClockTriangleFunction(rootElement);
    }

    private void updateScenario(Element rootElement) {
        String xpath = "./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]/scenario";
        List scenarios = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]/scenario", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element element : scenarios) {
            Pattern p;
            Matcher m;
            String hrefValue;
            Element clockElement;
            String[] split;
            String clockAttribute;
            Element recurrence = element.getChild("recurrence");
            if (recurrence != null) {
                recurrence.detach();
                String value = recurrence.getAttributeValue(VALUE);
                String unit = recurrence.getAttributeValue(UNIT);
                this.addCustomProperty(element, OLD_DEFINITION_V0_9_4, "recurrence=" + value + unit);
            }
            if ((clockAttribute = element.getAttributeValue(CLOCK)) != null && (split = clockAttribute.split("\\?type=Clock")).length == 2) {
                String clockRef = split[0];
                String clockType = this.getNewClockType(split[1]);
                element.setAttribute(CLOCK, String.valueOf(clockRef) + "?type=Clock" + clockType);
            }
            if ((clockElement = this.getSingleChild(element, CLOCK)) == null || (hrefValue = clockElement.getAttributeValue("href")) == null || !(m = (p = Pattern.compile("amlt:/#(.+)\\?type=Clock(.+)")).matcher(hrefValue)).find()) continue;
            String clockRef = m.group(1);
            String clockType = this.getNewClockType(m.group(2));
            clockElement.setAttribute("type", "am:Clock" + clockType, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            clockElement.setAttribute("href", "amlt:/#" + clockRef + "?type=Clock" + clockType);
        }
    }

    private void updateClockSineFunction(Element rootElement) {
        String xpath = "./stimuliModel/clocks[@xsi:type=\"am:ClockSinusFunction\"]";
        List clocks = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/clocks[@xsi:type=\"am:ClockSinusFunction\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        StringBuilder customPropsValue = new StringBuilder();
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockFunction", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            element.setAttribute("curveType", "sine");
            Attribute amplitude = element.getAttribute("amplitude");
            amplitude.detach();
            customPropsValue.append(this.getStringValue(amplitude));
            customPropsValue.append(" ");
            Attribute offset = element.getAttribute("yOffset");
            offset.detach();
            customPropsValue.append(this.getStringValue(offset));
            customPropsValue.append(" ");
            customPropsValue.append(this.extractPeriodAndShift(element));
            this.addCustomProperty(element, OLD_DEFINITION_V0_9_4, customPropsValue.toString().trim());
        }
    }

    private void updateClockTriangleFunction(Element rootElement) {
        String xpath = "./stimuliModel/clocks[@xsi:type=\"am:ClockTriangleFunction\"]";
        List clocks = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/clocks[@xsi:type=\"am:ClockTriangleFunction\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        StringBuilder customPropsValue = new StringBuilder();
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockFunction", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            element.setAttribute("curveType", "triangle");
            Attribute max = element.getAttribute("max");
            max.detach();
            customPropsValue.append(this.getStringValue(max));
            customPropsValue.append(" ");
            Attribute min = element.getAttribute("min");
            min.detach();
            customPropsValue.append(this.getStringValue(min));
            customPropsValue.append(" ");
            customPropsValue.append(this.extractPeriodAndShift(element));
            this.addCustomProperty(element, OLD_DEFINITION_V0_9_4, customPropsValue.toString().trim());
        }
    }

    private String extractPeriodAndShift(Element element) {
        StringBuilder str = new StringBuilder();
        List children = element.getChildren();
        for (Element e : children) {
            str.append(e.getName());
            str.append("=");
            str.append(e.getAttributeValue(VALUE));
            str.append(e.getAttributeValue(UNIT));
            str.append(" ");
        }
        element.removeChild("period");
        element.removeChild("shift");
        return str.toString();
    }

    private String getStringValue(Attribute attr) {
        return String.valueOf(attr.getName()) + "=" + attr.getValue();
    }

    private void updateClocksMulitplierList(Element rootElement) {
        String xpath = "./stimuliModel/clocks[@xsi:type=\"am:ClockMultiplierList\"]";
        List clocks = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/clocks[@xsi:type=\"am:ClockMultiplierList\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockStepList", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            this.updateClockEntries(element);
        }
    }

    private void updateClockEntries(Element clockElement) {
        List entries = clockElement.getChildren("entries");
        for (Element entry : entries) {
            Attribute multiplier = entry.getAttribute("multiplier");
            multiplier.detach();
            this.addCustomProperty(entry, OLD_DEFINITION_V0_9_4, "multiplier=" + multiplier.getValue());
        }
    }

    private void addCustomProperty(Element element, String key, String value) {
        Element customProps = new Element("customProperties");
        customProps.setAttribute("key", key);
        Element valueElement = new Element(VALUE);
        valueElement.setAttribute("type", "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        valueElement.setAttribute(VALUE, value);
        customProps.addContent((Content)valueElement);
        element.addContent((Content)customProps);
    }

    private Element getSingleChild(Element parent, String name) {
        List list = parent.getChildren(name);
        if (list.size() == 1) {
            return (Element)list.get(0);
        }
        return null;
    }

    private String getNewClockType(String oldClockType) {
        switch (oldClockType) {
            case "SinusFunction": 
            case "TriangleFunction": {
                return "Function";
            }
            case "MultiplierList": {
                return "StepList";
            }
        }
        return oldClockType;
    }
}

