/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters100.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.9", "output_model_version=1.0.0"}, service={IConverter.class})
public class EventModelConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from {0} to {1} : Executing EventModel converter for model file : {2}", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion(), targetFile.getName()});
        this.basicConvert(targetFile, fileDocumentMapping);
    }

    private void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateProcessEventType(rootElement);
    }

    private void updateProcessEventType(Element rootElement) {
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((String)this.getInputModelVersion(), (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        String xpathStr = "./eventModel/events";
        List events = HelperUtil.getXpathResult((Element)rootElement, (String)"./eventModel/events", Element.class, (Namespace[])new Namespace[]{am, xsi});
        if (events == null) {
            return;
        }
        for (Element event : events) {
            Attribute attribute;
            String type = event.getAttributeValue("type", xsi);
            if (!"am:ProcessEvent".equals(type) && !"am:ProcessChainEvent".equals(type) || (attribute = event.getAttribute("eventType")) == null || !"deadline".equals(attribute.getValue())) continue;
            this.logger.warn("{0}: Event type 'deadline' has been removed. 'deadline' is no longer supported in version {1}.", new Object[]{type, this.getOutputModelVersion()});
            event.removeAttribute(attribute);
        }
    }
}

