/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters094.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.3", "output_model_version=0.9.4"}, service={IConverter.class})
public class HwConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.3 to 0.9.4 : Executing Hw converter for model file : {0}", new Object[]{targetFile.getName()});
        Document document = filename2documentMap.get(targetFile);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updatePortInterface(rootElement);
    }

    private void updatePortInterface(Element rootElement) {
        String xpath = "./hwModel/structures//ports[@portInterface=\"ABH\"]";
        List portInterfaceElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./hwModel/structures//ports[@portInterface=\"ABH\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element portInterfaceElement : portInterfaceElements) {
            Attribute portInterfaceAttribute = portInterfaceElement.getAttribute("portInterface");
            portInterfaceAttribute.setValue("AHB");
        }
    }
}

