/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.ParameterType;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAssociation;
import org.eclipse.app4mc.amalthea.model.SchedulerDefinition;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.Pair;

@Validation(id="AM-OS-Mandatory-Scheduling-Parameters-Set", checks={"Mandatory scheduling parameters must be set"})
public class AmOSMandatorySchedulingParametersSet
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getScheduler();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject object, List<ValidationDiagnostic> results) {
        EObject eObject = object;
        if (eObject instanceof Scheduler) {
            void sc;
            Scheduler scheduler = (Scheduler)eObject;
            Scheduler cfr_ignored_0 = (Scheduler)eObject;
            SchedulerDefinition scDef = sc.getDefinition();
            if (scDef == null) {
                return;
            }
            List<SchedulingParameterDefinition> mandatoryAlgorithmParamDefs = scDef.getAlgorithmParameters().stream().filter(SchedulingParameterDefinition::isMandatory).toList();
            List<SchedulingParameterDefinition> mandatoryProcessParamDefs = scDef.getProcessParameters().stream().filter(SchedulingParameterDefinition::isMandatory).toList();
            if (mandatoryAlgorithmParamDefs.isEmpty() && mandatoryProcessParamDefs.isEmpty()) {
                return;
            }
            LinkedHashMap<Pair, List> missingSPs = new LinkedHashMap<Pair, List>();
            List<SchedulingParameterDefinition> missingAlgorithmParamDefs = mandatoryAlgorithmParamDefs.stream().filter(arg_0 -> AmOSMandatorySchedulingParametersSet.lambda$2((Scheduler)sc, arg_0)).toList();
            missingSPs.put(new Pair((Object)sc, (Object)ePackage.getISchedulingParameterContainer_SchedulingParameters()), missingAlgorithmParamDefs);
            void var13_10 = sc;
            if (var13_10 instanceof TaskScheduler) {
                void ts;
                TaskScheduler taskScheduler = (TaskScheduler)var13_10;
                TaskScheduler cfr_ignored_1 = (TaskScheduler)var13_10;
                for (TaskAllocation ta : ts.getTaskAllocations()) {
                    ArrayList<SchedulingParameterDefinition> perTAMissing = new ArrayList<SchedulingParameterDefinition>(mandatoryProcessParamDefs);
                    perTAMissing.removeAll(ta.getSchedulingParameters().keySet());
                    missingSPs.put(new Pair((Object)ta, (Object)ePackage.getISchedulingParameterContainer_SchedulingParameters()), perTAMissing);
                }
                for (SchedulerAssociation sa : ts.getChildAssociations()) {
                    ArrayList<SchedulingParameterDefinition> perSAMissing = new ArrayList<SchedulingParameterDefinition>(mandatoryProcessParamDefs);
                    perSAMissing.removeAll(sa.getSchedulingParameters().keySet());
                    missingSPs.put(new Pair((Object)sa, (Object)ePackage.getISchedulingParameterContainer_SchedulingParameters()), perSAMissing);
                }
            } else {
                void var16_16 = sc;
                if (var16_16 instanceof InterruptController) {
                    void ic;
                    InterruptController sa = (InterruptController)var16_16;
                    InterruptController cfr_ignored_2 = (InterruptController)var16_16;
                    for (ISRAllocation ia : ic.getIsrAllocations()) {
                        List perIAMissing = mandatoryProcessParamDefs.stream().filter(spd -> !spd.getName().equals("priority") || spd.getType() != ParameterType.INTEGER).collect(Collectors.toList());
                        missingSPs.put(new Pair((Object)ia, (Object)ePackage.getISRAllocation_Priority()), perIAMissing);
                    }
                }
            }
            missingSPs.forEach((eo, missingList) -> missingList.forEach(missing -> this.addIssue(results, (EObject)eo.getKey(), (EStructuralFeature)eo.getValue(), "Mandatory scheduling parameter \"" + missing.getName() + "\" is not set for " + this.objectInfo((EObject)eo.getKey()))));
        }
    }

    private static /* synthetic */ boolean lambda$2(Scheduler scheduler, SchedulingParameterDefinition e) {
        return !scheduler.getSchedulingParameters().containsKey((Object)e);
    }
}

